/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.next;

import com.questdb.common.Record;
import com.questdb.ql.analytic.next.AbstractNextAnalyticFunction;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.LongResolver;
import com.questdb.ql.map.MapUtils;
import com.questdb.ql.map.VirtualColumnTypeResolver;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.ThreadLocal;
import com.questdb.std.Unsafe;

public class NextPartitionedAnalyticFunction
extends AbstractNextAnalyticFunction {
    private static final ThreadLocal<VirtualColumnTypeResolver> tlPartitionByTypeResolver = new VirtualColumnTypeResolver.ResolverThreadLocal();
    private final DirectMap map;
    private final ObjList<VirtualColumn> partitionBy;

    public NextPartitionedAnalyticFunction(int pageSize, ObjList<VirtualColumn> partitionBy, VirtualColumn valueColumn) {
        super(pageSize, valueColumn);
        this.partitionBy = partitionBy;
        this.map = new DirectMap(pageSize, ((VirtualColumnTypeResolver)tlPartitionByTypeResolver.get()).of(partitionBy), LongResolver.INSTANCE);
    }

    @Override
    public void add(Record record) {
        DirectMapValues values = MapUtils.getMapValues(this.map, record, this.partitionBy);
        long address = this.pages.allocate(8L);
        if (!values.isNew()) {
            Unsafe.getUnsafe().putLong(values.getLong(0), record.getRowId());
        }
        values.putLong(0, address);
        Unsafe.getUnsafe().putLong(address, -1L);
    }

    @Override
    public void close() {
        super.close();
        Misc.free(this.map);
    }

    @Override
    public void reset() {
        super.reset();
        this.map.clear();
    }

    @Override
    public void toTop() {
        super.toTop();
        this.map.clear();
    }
}

