/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.prev;

import com.questdb.common.Record;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.RecordCursor;
import com.questdb.common.SymbolTable;
import com.questdb.ql.analytic.AnalyticFunction;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Unsafe;
import java.io.Closeable;
import java.io.IOException;

public abstract class AbstractPrevAnalyticFunction
implements AnalyticFunction,
Closeable {
    protected final long bufPtr;
    protected final VirtualColumn valueColumn;
    protected boolean nextNull = true;
    protected boolean closed = false;

    public AbstractPrevAnalyticFunction(VirtualColumn valueColumn) {
        this.valueColumn = valueColumn;
        this.bufPtr = Unsafe.malloc(8L);
    }

    @Override
    public void add(Record record) {
    }

    @Override
    public byte get() {
        return this.nextNull ? (byte)0 : Unsafe.getUnsafe().getByte(this.bufPtr);
    }

    @Override
    public boolean getBool() {
        return !this.nextNull && Unsafe.getUnsafe().getByte(this.bufPtr) == 1;
    }

    @Override
    public long getDate() {
        return this.getLong();
    }

    @Override
    public double getDouble() {
        return this.nextNull ? Double.NaN : Unsafe.getUnsafe().getDouble(this.bufPtr);
    }

    @Override
    public float getFloat() {
        return this.nextNull ? Float.NaN : Unsafe.getUnsafe().getFloat(this.bufPtr);
    }

    @Override
    public int getInt() {
        return this.nextNull ? (this.valueColumn.getType() == 8 ? -1 : Integer.MIN_VALUE) : Unsafe.getUnsafe().getInt(this.bufPtr);
    }

    @Override
    public long getLong() {
        return this.nextNull ? Long.MIN_VALUE : Unsafe.getUnsafe().getLong(this.bufPtr);
    }

    @Override
    public RecordColumnMetadata getMetadata() {
        return this.valueColumn;
    }

    @Override
    public short getShort() {
        return this.nextNull ? (short)0 : (short)Unsafe.getUnsafe().getInt(this.bufPtr);
    }

    @Override
    public CharSequence getSym() {
        return this.nextNull ? null : this.valueColumn.getSymbolTable().value(this.getInt());
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.valueColumn.getSymbolTable();
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void prepare(RecordCursor cursor) {
        this.valueColumn.prepare(cursor.getStorageFacade());
    }

    @Override
    public void reset() {
        this.nextNull = true;
    }

    @Override
    public void toTop() {
        this.nextNull = true;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        Unsafe.free(this.bufPtr, 8L);
        this.closed = true;
    }
}

