/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.prev;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.Record;
import com.questdb.ql.analytic.prev.AbstractPrevAnalyticFunction;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Unsafe;
import java.io.Closeable;
import java.io.IOException;

public class PrevAnalyticFunction
extends AbstractPrevAnalyticFunction
implements Closeable {
    private final long prevPtr = Unsafe.malloc(8L);
    private boolean firstPass = true;

    public PrevAnalyticFunction(VirtualColumn valueColumn) {
        super(valueColumn);
    }

    @Override
    public void prepareFor(Record record) {
        if (this.firstPass) {
            this.nextNull = true;
            this.firstPass = false;
        } else {
            if (this.nextNull) {
                this.nextNull = false;
            }
            Unsafe.getUnsafe().putLong(this.bufPtr, Unsafe.getUnsafe().getLong(this.prevPtr));
        }
        switch (this.valueColumn.getType()) {
            case 0: {
                Unsafe.getUnsafe().putByte(this.prevPtr, (byte)(this.valueColumn.getBool(record) ? 1 : 0));
                break;
            }
            case 1: {
                Unsafe.getUnsafe().putByte(this.prevPtr, this.valueColumn.get(record));
                break;
            }
            case 2: {
                Unsafe.getUnsafe().putDouble(this.prevPtr, this.valueColumn.getDouble(record));
                break;
            }
            case 3: {
                Unsafe.getUnsafe().putFloat(this.prevPtr, this.valueColumn.getFloat(record));
                break;
            }
            case 4: 
            case 8: {
                Unsafe.getUnsafe().putInt(this.prevPtr, this.valueColumn.getInt(record));
                break;
            }
            case 5: 
            case 10: {
                Unsafe.getUnsafe().putLong(this.prevPtr, this.valueColumn.getLong(record));
                break;
            }
            case 6: {
                Unsafe.getUnsafe().putShort(this.prevPtr, this.valueColumn.getShort(record));
                break;
            }
            default: {
                throw new JournalRuntimeException("Unsupported type: " + this.valueColumn.getType(), new Object[0]);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.firstPass = true;
    }

    @Override
    public void toTop() {
        super.toTop();
        this.firstPass = true;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        Unsafe.free(this.prevPtr, 8L);
    }
}

