/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.prev;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.Record;
import com.questdb.ql.analytic.prev.AbstractPrevAnalyticFunction;
import com.questdb.ql.map.ColumnTypeResolver;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.MapUtils;
import com.questdb.ql.map.VirtualColumnTypeResolver;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.ThreadLocal;
import com.questdb.std.Unsafe;
import java.io.Closeable;
import java.io.IOException;

public class PrevPartitionedAnalyticFunction
extends AbstractPrevAnalyticFunction
implements Closeable {
    private static final ThreadLocal<VirtualColumnTypeResolver> tlPartitionByTypeResolver = new VirtualColumnTypeResolver.ResolverThreadLocal();
    private static final ThreadLocal<VirtualColumnTypeResolver2> tlVirtualColumnResolver = new ThreadLocal<VirtualColumnTypeResolver2>(() -> new VirtualColumnTypeResolver2());
    private final DirectMap map;
    private final ObjList<VirtualColumn> partitionBy;

    public PrevPartitionedAnalyticFunction(int pageSize, ObjList<VirtualColumn> partitionBy, VirtualColumn valueColumn) {
        super(valueColumn);
        this.partitionBy = partitionBy;
        this.map = new DirectMap(pageSize, ((VirtualColumnTypeResolver)tlPartitionByTypeResolver.get()).of(partitionBy), ((VirtualColumnTypeResolver2)tlVirtualColumnResolver.get()).of(valueColumn));
    }

    @Override
    public void prepareFor(Record record) {
        DirectMapValues values = MapUtils.getMapValues(this.map, record, this.partitionBy);
        if (values.isNew()) {
            this.nextNull = true;
            this.store(record, values);
        } else {
            this.nextNull = false;
            switch (this.valueColumn.getType()) {
                case 0: {
                    Unsafe.getUnsafe().putByte(this.bufPtr, values.get(0));
                    values.putByte(0, (byte)(this.valueColumn.getBool(record) ? 1 : 0));
                    break;
                }
                case 1: {
                    Unsafe.getUnsafe().putByte(this.bufPtr, values.get(0));
                    values.putByte(0, this.valueColumn.get(record));
                    break;
                }
                case 2: {
                    Unsafe.getUnsafe().putDouble(this.bufPtr, values.getDouble(0));
                    values.putDouble(0, this.valueColumn.getDouble(record));
                    break;
                }
                case 3: {
                    Unsafe.getUnsafe().putFloat(this.bufPtr, values.getFloat(0));
                    values.putFloat(0, this.valueColumn.getFloat(record));
                    break;
                }
                case 4: 
                case 8: {
                    Unsafe.getUnsafe().putInt(this.bufPtr, values.getInt(0));
                    values.putInt(0, this.valueColumn.getInt(record));
                    break;
                }
                case 5: 
                case 10: {
                    Unsafe.getUnsafe().putLong(this.bufPtr, values.getLong(0));
                    values.putLong(0, this.valueColumn.getLong(record));
                    break;
                }
                case 6: {
                    Unsafe.getUnsafe().putShort(this.bufPtr, values.getShort(0));
                    values.putShort(0, this.valueColumn.getShort(record));
                    break;
                }
                default: {
                    throw new JournalRuntimeException("Unsupported type: " + this.valueColumn.getType(), new Object[0]);
                }
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.map.clear();
    }

    @Override
    public void toTop() {
        super.toTop();
        this.map.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        Misc.free(this.map);
    }

    private void store(Record record, DirectMapValues values) {
        switch (this.valueColumn.getType()) {
            case 0: {
                values.putByte(0, (byte)(this.valueColumn.getBool(record) ? 1 : 0));
                break;
            }
            case 1: {
                values.putByte(0, this.valueColumn.get(record));
                break;
            }
            case 2: {
                values.putDouble(0, this.valueColumn.getDouble(record));
                break;
            }
            case 3: {
                values.putFloat(0, this.valueColumn.getFloat(record));
                break;
            }
            case 4: 
            case 8: {
                values.putInt(0, this.valueColumn.getInt(record));
                break;
            }
            case 5: 
            case 10: {
                values.putLong(0, this.valueColumn.getLong(record));
                break;
            }
            case 6: {
                values.putShort(0, this.valueColumn.getShort(record));
                break;
            }
            default: {
                throw new JournalRuntimeException("Unsupported type: " + this.valueColumn.getType(), new Object[0]);
            }
        }
    }

    private static class VirtualColumnTypeResolver2
    implements ColumnTypeResolver {
        private VirtualColumn column;

        private VirtualColumnTypeResolver2() {
        }

        @Override
        public int count() {
            return 1;
        }

        @Override
        public int getColumnType(int index) {
            assert (index == 0);
            return this.column.getType();
        }

        public VirtualColumnTypeResolver2 of(VirtualColumn column) {
            this.column = column;
            return this;
        }
    }
}

