/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.prev;

import com.questdb.common.Record;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.RecordCursor;
import com.questdb.common.SymbolTable;
import com.questdb.ql.analytic.AnalyticFunction;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.str.CharSink;

public class PrevRowAnalyticFunction
implements AnalyticFunction {
    private final VirtualColumn valueColumn;
    private RecordCursor parent;
    private long prevRowId = -1L;
    private long currentRowId = -1L;
    private Record record;

    public PrevRowAnalyticFunction(VirtualColumn valueColumn) {
        this.valueColumn = valueColumn;
    }

    @Override
    public void add(Record record) {
    }

    @Override
    public byte get() {
        return this.prevRowId == -1L ? (byte)0 : this.valueColumn.get(this.getParentRecord());
    }

    @Override
    public boolean getBool() {
        return this.prevRowId != -1L && this.valueColumn.getBool(this.getParentRecord());
    }

    @Override
    public long getDate() {
        return this.prevRowId == -1L ? Long.MIN_VALUE : this.valueColumn.getDate(this.getParentRecord());
    }

    @Override
    public double getDouble() {
        return this.prevRowId == -1L ? Double.NaN : this.valueColumn.getDouble(this.getParentRecord());
    }

    @Override
    public float getFloat() {
        return this.prevRowId == -1L ? Float.NaN : this.valueColumn.getFloat(this.getParentRecord());
    }

    @Override
    public CharSequence getFlyweightStr() {
        return this.prevRowId == -1L ? null : this.valueColumn.getFlyweightStr(this.getParentRecord());
    }

    @Override
    public CharSequence getFlyweightStrB() {
        return this.prevRowId == -1L ? null : this.valueColumn.getFlyweightStrB(this.getParentRecord());
    }

    @Override
    public int getInt() {
        if (this.prevRowId == -1L) {
            if (this.valueColumn.getType() == 8) {
                return -1;
            }
            return Integer.MIN_VALUE;
        }
        return this.valueColumn.getInt(this.getParentRecord());
    }

    @Override
    public long getLong() {
        return this.prevRowId == -1L ? Long.MIN_VALUE : this.valueColumn.getLong(this.getParentRecord());
    }

    @Override
    public RecordColumnMetadata getMetadata() {
        return this.valueColumn;
    }

    @Override
    public short getShort() {
        return this.prevRowId == -1L ? (short)0 : this.valueColumn.getShort(this.getParentRecord());
    }

    @Override
    public void getStr(CharSink sink) {
        if (this.prevRowId > -1L) {
            this.valueColumn.getStr(this.getParentRecord(), sink);
        }
    }

    @Override
    public int getStrLen() {
        return this.prevRowId == -1L ? -1 : this.valueColumn.getStrLen(this.getParentRecord());
    }

    @Override
    public CharSequence getSym() {
        return this.prevRowId == -1L ? null : this.valueColumn.getSym(this.getParentRecord());
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.valueColumn.getSymbolTable();
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void prepare(RecordCursor cursor) {
        this.parent = cursor;
        this.record = cursor.newRecord();
        this.valueColumn.prepare(cursor.getStorageFacade());
    }

    @Override
    public void prepareFor(Record record) {
        this.prevRowId = this.currentRowId;
        this.currentRowId = record.getRowId();
    }

    @Override
    public void reset() {
        this.currentRowId = -1L;
        this.prevRowId = -1L;
    }

    @Override
    public void toTop() {
        this.reset();
    }

    private Record getParentRecord() {
        this.parent.recordAt(this.record, this.prevRowId);
        return this.record;
    }
}

