/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.prev;

import com.questdb.common.Record;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.RecordCursor;
import com.questdb.ql.analytic.AnalyticFunction;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Chars;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.DirectCharSequence;
import com.questdb.store.MMappedSymbolTable;
import java.io.Closeable;
import java.io.IOException;

public class PrevStrAnalyticFunction
implements AnalyticFunction,
Closeable {
    private final DirectCharSequence cs = new DirectCharSequence();
    private final DirectCharSequence csB = new DirectCharSequence();
    private final VirtualColumn valueColumn;
    private boolean closed = false;
    private long bufA = 0L;
    private int bufALen = -1;
    private int bufASz = 0;
    private long bufB = 0L;
    private int bufBLen = -1;
    private int bufBSz = 0;
    private long buf;
    private int bufLen;

    public PrevStrAnalyticFunction(VirtualColumn valueColumn) {
        this.valueColumn = valueColumn;
        this.bufASz = 32;
        this.bufA = Unsafe.malloc(this.bufASz * 2);
        this.bufBSz = 32;
        this.bufB = Unsafe.malloc(this.bufBSz * 2);
        this.buf = this.bufA;
        this.bufLen = this.bufALen;
    }

    @Override
    public void add(Record record) {
    }

    @Override
    public CharSequence getFlyweightStr() {
        return this.bufLen == -1 ? null : this.cs;
    }

    @Override
    public CharSequence getFlyweightStrB() {
        return this.bufLen == -1 ? null : this.csB.of(this.cs.getLo(), this.cs.getHi());
    }

    @Override
    public RecordColumnMetadata getMetadata() {
        return this.valueColumn;
    }

    @Override
    public void getStr(CharSink sink) {
        if (this.bufLen > -1) {
            sink.put(this.cs);
        }
    }

    @Override
    public int getStrLen() {
        return this.bufLen == -1 ? -1 : this.bufLen;
    }

    @Override
    public MMappedSymbolTable getSymbolTable() {
        return null;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void prepare(RecordCursor cursor) {
    }

    @Override
    public void prepareFor(Record record) {
        int sz;
        CharSequence cs = this.valueColumn.getFlyweightStr(record);
        int n = sz = this.buf == this.bufA ? this.bufASz : this.bufBSz;
        if (cs == null) {
            this.bufLen = -1;
        } else {
            int l = cs.length();
            if (l > sz) {
                long b = Unsafe.malloc(l * 2);
                Chars.putCharsOnly(b, cs);
                Unsafe.free(this.buf, sz * 2);
                if (this.buf == this.bufA) {
                    this.bufASz = l;
                    this.bufA = b;
                    this.bufALen = l;
                    this.buf = this.bufB;
                    this.bufLen = this.bufBLen;
                } else {
                    this.bufBSz = l;
                    this.bufB = b;
                    this.bufBLen = l;
                    this.buf = this.bufA;
                    this.bufLen = this.bufALen;
                }
            } else {
                Chars.putCharsOnly(this.buf, cs);
                if (this.buf == this.bufA) {
                    this.bufALen = l;
                    this.buf = this.bufB;
                    this.bufLen = this.bufBLen;
                } else {
                    this.bufBLen = l;
                    this.buf = this.bufA;
                    this.bufLen = this.bufALen;
                }
            }
        }
        this.cs.of(this.buf, this.buf + (long)(this.bufLen * 2));
    }

    @Override
    public void reset() {
        this.bufALen = -1;
        this.bufBLen = -1;
        this.buf = this.bufA;
    }

    @Override
    public void toTop() {
        this.reset();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        Unsafe.free(this.bufA, this.bufASz * 2);
        Unsafe.free(this.bufB, this.bufBSz * 2);
        this.closed = true;
    }
}

