/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.prev;

import com.questdb.common.Record;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.RecordCursor;
import com.questdb.ql.analytic.AnalyticFunction;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapEntry;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.LongByteResolver;
import com.questdb.ql.map.MapUtils;
import com.questdb.ql.map.VirtualColumnTypeResolver;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Chars;
import com.questdb.std.Misc;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.ThreadLocal;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.DirectCharSequence;
import com.questdb.store.MMappedSymbolTable;
import java.io.Closeable;
import java.io.IOException;

public class PrevStrPartitionedAnalyticFunction
implements AnalyticFunction,
Closeable {
    private static final ThreadLocal<VirtualColumnTypeResolver> tlPartitionByTypeResolver = new VirtualColumnTypeResolver.ResolverThreadLocal();
    private final DirectMap map;
    private final DirectCharSequence cs = new DirectCharSequence();
    private final DirectCharSequence csB = new DirectCharSequence();
    private final ObjList<VirtualColumn> partitionBy;
    private final VirtualColumn valueColumn;
    private long bufPtr = 0L;
    private int bufPtrLen = 0;
    private boolean nextNull = true;
    private boolean closed = false;

    public PrevStrPartitionedAnalyticFunction(int pageSize, ObjList<VirtualColumn> partitionBy, VirtualColumn valueColumn) {
        this.partitionBy = partitionBy;
        this.valueColumn = valueColumn;
        this.map = new DirectMap(pageSize, ((VirtualColumnTypeResolver)tlPartitionByTypeResolver.get()).of(partitionBy), LongByteResolver.INSTANCE);
    }

    @Override
    public void add(Record record) {
    }

    @Override
    public CharSequence getFlyweightStr() {
        return this.nextNull ? null : this.cs;
    }

    @Override
    public CharSequence getFlyweightStrB() {
        return this.nextNull ? null : this.csB.of(this.cs.getLo(), this.cs.getHi());
    }

    @Override
    public RecordColumnMetadata getMetadata() {
        return this.valueColumn;
    }

    @Override
    public void getStr(CharSink sink) {
        if (this.nextNull) {
            return;
        }
        sink.put(this.cs);
    }

    @Override
    public int getStrLen() {
        return this.nextNull ? -1 : this.cs.length();
    }

    @Override
    public MMappedSymbolTable getSymbolTable() {
        return null;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void prepare(RecordCursor cursor) {
    }

    @Override
    public void prepareFor(Record record) {
        DirectMapValues values = MapUtils.getMapValues(this.map, record, this.partitionBy);
        CharSequence str = this.valueColumn.getFlyweightStr(record);
        if (values.isNew()) {
            this.nextNull = true;
            if (str == null) {
                this.allocAndStoreNull(values);
            } else {
                this.allocAndStore(str, values);
            }
        } else {
            this.nextNull = false;
            long ptr = values.getLong(0);
            int len = values.getInt(1);
            this.copyToBuffer(ptr);
            if (str == null) {
                Unsafe.getUnsafe().putInt(ptr, -1);
            } else if (PrevStrPartitionedAnalyticFunction.toByteLen(str.length()) > len) {
                Unsafe.free(ptr, len);
                this.allocAndStore(str, values);
            } else {
                Chars.strcpyw(str, ptr);
            }
        }
    }

    @Override
    public void reset() {
        this.freeMapEntrie();
        this.map.clear();
    }

    @Override
    public void toTop() {
        this.freeMapEntrie();
        this.map.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.freeMapEntrie();
        Misc.free(this.map);
        if (this.bufPtr != 0L) {
            Unsafe.free(this.bufPtr, this.bufPtrLen);
        }
        this.closed = true;
    }

    private static int toByteLen(int charLen) {
        return charLen * 2 + 4;
    }

    private void allocAndStore(CharSequence str, DirectMapValues values) {
        int l = Numbers.ceilPow2(PrevStrPartitionedAnalyticFunction.toByteLen(str.length()));
        long ptr = Unsafe.malloc(l);
        values.putLong(0, ptr);
        values.putInt(1, l);
        Chars.strcpyw(str, ptr);
    }

    private void allocAndStoreNull(DirectMapValues values) {
        int l = 64;
        long ptr = Unsafe.malloc(l);
        values.putLong(0, ptr);
        values.putInt(1, l);
        Unsafe.getUnsafe().putInt(ptr, -1);
    }

    private void copyToBuffer(long ptr) {
        int l = Unsafe.getUnsafe().getInt(ptr);
        if (l == -1) {
            this.nextNull = true;
            return;
        }
        if ((l = PrevStrPartitionedAnalyticFunction.toByteLen(l)) > this.bufPtrLen) {
            if (this.bufPtr != 0L) {
                Unsafe.free(this.bufPtr, this.bufPtrLen);
            }
            this.bufPtrLen = Numbers.ceilPow2(l);
            this.bufPtr = Unsafe.malloc(this.bufPtrLen);
            this.cs.of(this.bufPtr + 4L, this.bufPtr + (long)this.bufPtrLen);
        } else {
            this.cs.of(this.bufPtr + 4L, this.bufPtr + (long)l);
        }
        Unsafe.getUnsafe().copyMemory(ptr, this.bufPtr, l);
    }

    private void freeMapEntrie() {
        for (DirectMapEntry e : this.map) {
            Unsafe.free(e.getLong(0), e.getInt(1));
        }
    }
}

