/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.prev;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.ql.analytic.prev.AbstractPrevAnalyticFunction;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.LongResolver;
import com.questdb.ql.map.MapUtils;
import com.questdb.ql.map.VirtualColumnTypeResolver;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.ThreadLocal;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import java.io.Closeable;
import java.io.IOException;

public class PrevStrRowPartitionedAnalyticFunction
extends AbstractPrevAnalyticFunction
implements Closeable {
    private static final ThreadLocal<VirtualColumnTypeResolver> tlPartitionByTypeResolver = new VirtualColumnTypeResolver.ResolverThreadLocal();
    private final DirectMap map;
    private final ObjList<VirtualColumn> partitionBy;
    private RecordCursor parent;

    public PrevStrRowPartitionedAnalyticFunction(int pageSize, ObjList<VirtualColumn> partitionBy, VirtualColumn valueColumn) {
        super(valueColumn);
        this.partitionBy = partitionBy;
        this.map = new DirectMap(pageSize, ((VirtualColumnTypeResolver)tlPartitionByTypeResolver.get()).of(partitionBy), LongResolver.INSTANCE);
    }

    @Override
    public byte get() {
        return this.nextNull ? (byte)0 : this.valueColumn.get(this.getParentRecord());
    }

    @Override
    public boolean getBool() {
        return !this.nextNull && this.valueColumn.getBool(this.getParentRecord());
    }

    @Override
    public long getDate() {
        return this.nextNull ? Long.MIN_VALUE : this.valueColumn.getDate(this.getParentRecord());
    }

    @Override
    public double getDouble() {
        return this.nextNull ? Double.NaN : this.valueColumn.getDouble(this.getParentRecord());
    }

    @Override
    public float getFloat() {
        return this.nextNull ? Float.NaN : this.valueColumn.getFloat(this.getParentRecord());
    }

    @Override
    public CharSequence getFlyweightStr() {
        return this.nextNull ? null : this.valueColumn.getFlyweightStr(this.getParentRecord());
    }

    @Override
    public CharSequence getFlyweightStrB() {
        return this.nextNull ? null : this.valueColumn.getFlyweightStrB(this.getParentRecord());
    }

    @Override
    public int getInt() {
        return this.nextNull ? Integer.MIN_VALUE : this.valueColumn.getInt(this.getParentRecord());
    }

    @Override
    public long getLong() {
        return this.nextNull ? Long.MIN_VALUE : this.valueColumn.getLong(this.getParentRecord());
    }

    @Override
    public short getShort() {
        return this.nextNull ? (short)0 : this.valueColumn.getShort(this.getParentRecord());
    }

    @Override
    public void getStr(CharSink sink) {
        if (this.nextNull) {
            return;
        }
        this.valueColumn.getStr(this.getParentRecord(), sink);
    }

    @Override
    public int getStrLen() {
        return this.nextNull ? -1 : this.valueColumn.getStrLen(this.getParentRecord());
    }

    @Override
    public CharSequence getSym() {
        return this.nextNull ? null : this.valueColumn.getSym(this.getParentRecord());
    }

    @Override
    public void prepare(RecordCursor cursor) {
        this.parent = cursor;
    }

    @Override
    public void reset() {
        super.reset();
        this.map.clear();
    }

    @Override
    public void toTop() {
        super.toTop();
        this.map.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        Misc.free(this.map);
    }

    @Override
    public void prepareFor(Record record) {
        DirectMapValues values = MapUtils.getMapValues(this.map, record, this.partitionBy);
        if (values.isNew()) {
            this.nextNull = true;
        } else {
            this.nextNull = false;
            Unsafe.getUnsafe().putLong(this.bufPtr, values.getLong(0));
        }
        values.putLong(0, record.getRowId());
    }

    private Record getParentRecord() {
        return this.parent.recordAt(Unsafe.getUnsafe().getLong(this.bufPtr));
    }
}

