/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.interval;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.parser.sql.IntervalCompiler;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.RecordSource;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.std.LongList;
import com.questdb.std.Misc;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;

public class IntervalRecordSource
extends AbstractCombinedRecordSource {
    private final RecordSource delegate;
    private final LongList intervals;
    private final int timestampIndex;
    private final int intervalCount;
    private RecordCursor cursor;
    private Record record;
    private boolean needRecord = true;
    private int intervalIndex = 0;

    public IntervalRecordSource(RecordSource delegate, LongList intervals, int timestampIndex) {
        this.delegate = delegate;
        this.intervals = intervals;
        this.intervalCount = intervals.size() / 2;
        this.timestampIndex = timestampIndex;
    }

    @Override
    public void close() {
        Misc.free(this.delegate);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.intervalIndex = 0;
        this.needRecord = true;
        this.cursor = this.delegate.prepareCursor(factory, cancellationHandler);
        return this;
    }

    @Override
    public Record getRecord() {
        return this.delegate.getRecord();
    }

    @Override
    public Record newRecord() {
        return this.delegate.newRecord();
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.cursor.getStorageFacade();
    }

    @Override
    public void releaseCursor() {
        this.cursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.needRecord = true;
        this.intervalIndex = 0;
        this.cursor.toTop();
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.intervalIndex == this.intervalCount) {
                return false;
            }
            if (this.needRecord) {
                if (this.cursor.hasNext()) {
                    this.record = (Record)this.cursor.next();
                } else {
                    return false;
                }
            }
            long t = this.record.getDate(this.timestampIndex);
            if (IntervalCompiler.getIntervalHi(this.intervals, this.intervalIndex) < t) {
                this.needRecord = false;
                ++this.intervalIndex;
                continue;
            }
            this.needRecord = true;
            if (IntervalCompiler.getIntervalLo(this.intervals, this.intervalIndex) <= t) break;
        }
        return true;
    }

    @Override
    public Record next() {
        return this.record;
    }

    @Override
    public Record recordAt(long rowId) {
        return this.cursor.recordAt(rowId);
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.cursor.recordAt(record, atRowId);
    }

    @Override
    public boolean supportsRowIdAccess() {
        return this.delegate.supportsRowIdAccess();
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("IntervalRecordSource").put(',');
        sink.putQuoted("src").put(':').put(this.delegate).put(',');
        sink.putQuoted("interval").put(':').put(IntervalCompiler.asIntervalStr(this.intervals));
        sink.put('}');
    }
}

