/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.interval;

import com.questdb.common.StorageFacade;
import com.questdb.parser.sql.IntervalCompiler;
import com.questdb.ql.PartitionCursor;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.PartitionSource;
import com.questdb.std.ImmutableIterator;
import com.questdb.std.LongList;
import com.questdb.std.str.CharSink;
import com.questdb.store.BSearchType;
import com.questdb.store.FixedColumn;
import com.questdb.store.Partition;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

public class MultiIntervalPartitionSource
implements PartitionSource,
PartitionCursor,
ImmutableIterator<PartitionSlice> {
    private final PartitionSource partitionSource;
    private final PartitionSlice result = new PartitionSlice();
    private final LongList intervals;
    private final int intervalCount;
    private PartitionCursor partitionCursor;
    private boolean needPartition = true;
    private PartitionSlice slice = null;
    private FixedColumn timestampColumn = null;
    private long nextRowLo;
    private int intervalIndex = 0;

    public MultiIntervalPartitionSource(PartitionSource partitionSource, LongList intervals) {
        this.partitionSource = partitionSource;
        this.intervals = intervals;
        this.intervalCount = intervals.size() / 2;
    }

    @Override
    public JournalMetadata getMetadata() {
        return this.partitionSource.getMetadata();
    }

    @Override
    public PartitionCursor prepareCursor(ReaderFactory readerFactory) {
        this.intervalIndex = 0;
        this.needPartition = true;
        this.partitionCursor = this.partitionSource.prepareCursor(readerFactory);
        return this;
    }

    @Override
    public Partition getPartition(int index) {
        return this.partitionCursor.getPartition(index);
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.partitionCursor.getStorageFacade();
    }

    @Override
    public void releaseCursor() {
        if (this.partitionCursor != null) {
            this.partitionCursor.releaseCursor();
        }
    }

    @Override
    public void toTop() {
        this.intervalIndex = 0;
        this.needPartition = true;
        this.partitionCursor.toTop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasNext() {
        long sliceHi;
        long sliceLo;
        long hi;
        long lo;
        long sliceRowHi;
        long sliceRowLo;
        while (true) {
            if (this.intervalIndex == this.intervalCount) {
                return false;
            }
            if (this.needPartition) {
                if (!this.partitionCursor.hasNext()) return false;
                this.slice = (PartitionSlice)this.partitionCursor.next();
                sliceRowLo = this.nextRowLo = this.slice.lo;
                long l = sliceRowHi = this.slice.calcHi ? this.slice.partition.size() - 1L : this.slice.hi;
                if (sliceRowHi < 0L) continue;
                this.timestampColumn = this.slice.partition.getTimestampColumn();
            } else {
                sliceRowLo = this.nextRowLo;
                sliceRowHi = this.slice.calcHi ? this.slice.partition.size() - 1L : this.slice.hi;
            }
            lo = IntervalCompiler.getIntervalLo(this.intervals, this.intervalIndex);
            hi = IntervalCompiler.getIntervalHi(this.intervals, this.intervalIndex);
            if (hi < this.slice.partition.getInterval().getLo() || hi < (sliceLo = this.timestampColumn.getLong(sliceRowLo))) {
                this.needPartition = false;
                ++this.intervalIndex;
                continue;
            }
            if (lo <= this.slice.partition.getInterval().getHi() && lo <= (sliceHi = this.timestampColumn.getLong(sliceRowHi))) break;
            this.needPartition = true;
        }
        this.result.partition = this.slice.partition;
        this.result.lo = lo > sliceLo ? this.slice.partition.indexOf(lo, BSearchType.NEWER_OR_SAME) : sliceRowLo;
        if (hi < sliceHi) {
            this.result.hi = this.slice.partition.indexOf(hi, BSearchType.OLDER_OR_SAME, this.result.lo, sliceRowHi);
            this.needPartition = false;
            ++this.intervalIndex;
        } else {
            this.result.hi = sliceRowHi;
            this.needPartition = true;
            if (hi == sliceHi) {
                ++this.intervalIndex;
            }
        }
        this.nextRowLo = this.result.hi + 1L;
        return true;
    }

    @Override
    public PartitionSlice next() {
        return this.result;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("MultiIntervalPartitionSource").put(',');
        sink.putQuoted("psrc").put(':').put(this.partitionSource).put(',');
        sink.putQuoted("isrc").put(':').put(IntervalCompiler.asIntervalStr(this.intervals));
        sink.put('}');
    }
}

