/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.NullableRecord;
import com.questdb.ql.RecordSource;
import com.questdb.ql.SplitRecordMetadata;
import com.questdb.ql.join.SplitRecord;
import com.questdb.ql.join.SplitRecordStorageFacade;
import com.questdb.ql.join.asof.FixRecordHolder;
import com.questdb.ql.join.asof.RecordHolder;
import com.questdb.ql.join.asof.RowidRecordHolder;
import com.questdb.ql.join.asof.VarRecordHolder;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.std.Misc;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;
import java.io.Closeable;

public class AsOfJoinRecordSource
extends AbstractCombinedRecordSource
implements Closeable {
    private final RecordSource master;
    private final RecordSource slave;
    private final SplitRecordMetadata metadata;
    private final int masterTimestampIndex;
    private final int slaveTimestampIndex;
    private final SplitRecord record;
    private final RecordHolder recordHolder;
    private final RecordHolder delayedHolder;
    private final SplitRecordStorageFacade storageFacade;
    private final NullableRecord nullableRecord;
    private RecordCursor masterCursor;
    private RecordCursor slaveCursor;

    public AsOfJoinRecordSource(RecordSource master, int masterTimestampIndex, RecordSource slave, int slaveTimestampIndex) {
        Record slaveRecord;
        this.master = master;
        this.masterTimestampIndex = masterTimestampIndex;
        this.slave = slave;
        this.slaveTimestampIndex = slaveTimestampIndex;
        this.metadata = new SplitRecordMetadata(master.getMetadata(), slave.getMetadata());
        if (slave.supportsRowIdAccess()) {
            this.recordHolder = new RowidRecordHolder();
            this.delayedHolder = new RowidRecordHolder();
            slaveRecord = slave.getRecord();
        } else {
            boolean var = false;
            int n = slave.getMetadata().getColumnCount();
            block4: for (int i = 0; i < n; ++i) {
                switch (slave.getMetadata().getColumnQuick(i).getType()) {
                    case 9: {
                        throw new JournalRuntimeException("Binary columns are not supported", new Object[0]);
                    }
                    case 7: {
                        var = true;
                        break block4;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
            if (var) {
                this.recordHolder = new VarRecordHolder(slave.getMetadata());
                this.delayedHolder = new VarRecordHolder(slave.getMetadata());
                slaveRecord = (VarRecordHolder)this.recordHolder;
            } else {
                this.recordHolder = new FixRecordHolder(slave.getMetadata());
                this.delayedHolder = new FixRecordHolder(slave.getMetadata());
                slaveRecord = (FixRecordHolder)this.recordHolder;
            }
        }
        this.nullableRecord = new NullableRecord(slaveRecord);
        this.record = new SplitRecord(master.getMetadata().getColumnCount(), slave.getMetadata().getColumnCount(), master.getRecord(), this.nullableRecord);
        this.storageFacade = new SplitRecordStorageFacade(master.getMetadata().getColumnCount());
    }

    @Override
    public void close() {
        Misc.free(this.recordHolder);
        Misc.free(this.delayedHolder);
        Misc.free(this.master);
        Misc.free(this.slave);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.recordHolder.clear();
        this.delayedHolder.clear();
        this.masterCursor = this.master.prepareCursor(factory, cancellationHandler);
        this.slaveCursor = this.slave.prepareCursor(factory, cancellationHandler);
        this.recordHolder.setCursor(this.slaveCursor);
        this.delayedHolder.setCursor(this.slaveCursor);
        this.storageFacade.prepare(this.masterCursor.getStorageFacade(), this.slaveCursor.getStorageFacade());
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new SplitRecord(this.master.getMetadata().getColumnCount(), this.slave.getMetadata().getColumnCount(), this.master.getRecord(), this.nullableRecord);
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void releaseCursor() {
        this.recordHolder.clear();
        this.delayedHolder.clear();
        this.masterCursor.releaseCursor();
        this.slaveCursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.recordHolder.clear();
        this.delayedHolder.clear();
        this.masterCursor.toTop();
        this.slaveCursor.toTop();
    }

    @Override
    public boolean hasNext() {
        return this.masterCursor.hasNext();
    }

    @Override
    public Record next() {
        long ts = ((Record)this.masterCursor.next()).getDate(this.masterTimestampIndex);
        Record delayed = this.delayedHolder.peek();
        if (delayed != null) {
            if (ts > delayed.getDate(this.slaveTimestampIndex)) {
                this.recordHolder.write(delayed);
                this.delayedHolder.clear();
            } else {
                this.nullableRecord.set_null(true);
                return this.record;
            }
        }
        while (this.slaveCursor.hasNext()) {
            Record slave = (Record)this.slaveCursor.next();
            if (ts > slave.getDate(this.slaveTimestampIndex)) {
                this.recordHolder.write(slave);
                continue;
            }
            this.delayedHolder.write(slave);
            this.nullableRecord.set_null(this.recordHolder.peek() == null);
            this.recordHolder.clear();
            return this.record;
        }
        this.nullableRecord.set_null(this.recordHolder.peek() == null);
        return this.record;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("AsOfJoinRecordSource").put(',');
        sink.putQuoted("master").put(':').put(this.master).put(',');
        sink.putQuoted("slave").put(':').put(this.slave).put(',');
        sink.putQuoted("masterTsIndex").put(':').put(this.masterTimestampIndex).put(',');
        sink.putQuoted("slaveTsIndex").put(':').put(this.slaveTimestampIndex);
        sink.put('}');
    }
}

