/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.NullableRecord;
import com.questdb.ql.RecordSource;
import com.questdb.ql.SplitRecordMetadata;
import com.questdb.ql.join.SplitRecord;
import com.questdb.ql.join.SplitRecordStorageFacade;
import com.questdb.ql.join.asof.FixRecordHolder;
import com.questdb.ql.join.asof.LastFixRecordMap;
import com.questdb.ql.join.asof.LastRecordMap;
import com.questdb.ql.join.asof.LastRowIdRecordMap;
import com.questdb.ql.join.asof.LastVarRecordMap;
import com.questdb.ql.join.asof.RecordHolder;
import com.questdb.ql.join.asof.RowidRecordHolder;
import com.questdb.ql.join.asof.VarRecordHolder;
import com.questdb.ql.map.RecordKeyCopier;
import com.questdb.ql.map.RecordKeyCopierCompiler;
import com.questdb.ql.map.TypeListResolver;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.IntList;
import com.questdb.std.Misc;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;
import java.io.Closeable;

public class AsOfPartitionedJoinRecordSource
extends AbstractCombinedRecordSource
implements Closeable {
    private static final TypeListResolver.TypeListResolverThreadLocal tlTypeListResolver = new TypeListResolver.TypeListResolverThreadLocal();
    private final LastRecordMap map;
    private final RecordHolder holder;
    private final RecordSource master;
    private final RecordSource slave;
    private final SplitRecordMetadata metadata;
    private final int masterTimestampIndex;
    private final int slaveTimestampIndex;
    private final SplitRecord record;
    private final SplitRecordStorageFacade storageFacade;
    private final NullableRecord nullableRecord;
    private RecordCursor masterCursor;
    private RecordCursor slaveCursor;
    private boolean closed = false;

    public AsOfPartitionedJoinRecordSource(RecordSource master, int masterTimestampIndex, RecordSource slave, int slaveTimestampIndex, CharSequenceHashSet masterKeyColumns, CharSequenceHashSet slaveKeyColumns, int dataPageSize, int offsetPageSize, int rowIdPageSize, RecordKeyCopierCompiler compiler) {
        this.master = master;
        this.masterTimestampIndex = masterTimestampIndex;
        this.slave = slave;
        this.slaveTimestampIndex = slaveTimestampIndex;
        IntList indices = new IntList();
        IntList types = new IntList();
        RecordMetadata m = master.getMetadata();
        int n = masterKeyColumns.size();
        for (int i = 0; i < n; ++i) {
            int index = m.getColumnIndex(masterKeyColumns.get(i));
            indices.add(index);
            types.add(m.getColumnQuick(index).getType());
        }
        RecordKeyCopier masterCopier = compiler.compile(m, indices, true);
        indices.clear();
        m = slave.getMetadata();
        int n2 = slaveKeyColumns.size();
        for (int i = 0; i < n2; ++i) {
            indices.add(m.getColumnIndex(slaveKeyColumns.get(i)));
        }
        RecordKeyCopier slaveCopier = compiler.compile(m, indices, true);
        if (slave.supportsRowIdAccess()) {
            this.map = new LastRowIdRecordMap(((TypeListResolver)tlTypeListResolver.get()).of(types), slave.getMetadata(), masterCopier, slaveCopier, rowIdPageSize, slave.getRecord());
            this.holder = new RowidRecordHolder();
        } else {
            boolean var = false;
            int n3 = slave.getMetadata().getColumnCount();
            block6: for (int i = 0; i < n3; ++i) {
                switch (slave.getMetadata().getColumnQuick(i).getType()) {
                    case 9: {
                        throw new JournalRuntimeException("Binary columns are not supported", new Object[0]);
                    }
                    case 7: {
                        if (masterKeyColumns.contains(slave.getMetadata().getColumnName(i))) break block6;
                        var = true;
                        break block6;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
            if (var) {
                this.map = new LastVarRecordMap(((TypeListResolver)tlTypeListResolver.get()).of(types), slave.getMetadata(), masterCopier, slaveCopier, dataPageSize, offsetPageSize);
                this.holder = new VarRecordHolder(slave.getMetadata());
            } else {
                this.map = new LastFixRecordMap(((TypeListResolver)tlTypeListResolver.get()).of(types), slave.getMetadata(), masterCopier, slaveCopier, dataPageSize, offsetPageSize);
                this.holder = new FixRecordHolder(slave.getMetadata());
            }
        }
        this.metadata = new SplitRecordMetadata(master.getMetadata(), this.map.getMetadata());
        this.nullableRecord = new NullableRecord(this.map.getRecord());
        this.record = new SplitRecord(master.getMetadata().getColumnCount(), this.map.getMetadata().getColumnCount(), master.getRecord(), this.nullableRecord);
        this.storageFacade = new SplitRecordStorageFacade(master.getMetadata().getColumnCount());
    }

    @Override
    public void close() {
        assert (!this.closed);
        Misc.free(this.map);
        Misc.free(this.holder);
        Misc.free(this.master);
        Misc.free(this.slave);
        this.closed = true;
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.map.reset();
        this.holder.clear();
        this.masterCursor = this.master.prepareCursor(factory, cancellationHandler);
        this.slaveCursor = this.slave.prepareCursor(factory, cancellationHandler);
        this.map.setSlaveCursor(this.slaveCursor);
        this.holder.setCursor(this.slaveCursor);
        this.storageFacade.prepare(this.masterCursor.getStorageFacade(), this.map.getStorageFacade());
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new SplitRecord(this.master.getMetadata().getColumnCount(), this.map.getMetadata().getColumnCount(), this.master.getRecord(), this.nullableRecord);
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void releaseCursor() {
        this.map.reset();
        this.holder.clear();
        this.masterCursor.releaseCursor();
        this.slaveCursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.map.reset();
        this.holder.clear();
        this.masterCursor.toTop();
        this.slaveCursor.toTop();
    }

    @Override
    public boolean hasNext() {
        return this.masterCursor.hasNext();
    }

    @Override
    public Record next() {
        Record master = (Record)this.masterCursor.next();
        long ts = master.getDate(this.masterTimestampIndex);
        Record delayed = this.holder.peek();
        if (delayed != null) {
            if (ts > delayed.getDate(this.slaveTimestampIndex)) {
                this.map.put(delayed);
                this.holder.clear();
            } else {
                this.nullableRecord.set_null(true);
                return this.record;
            }
        }
        while (this.slaveCursor.hasNext()) {
            Record slave = (Record)this.slaveCursor.next();
            if (ts > slave.getDate(this.slaveTimestampIndex)) {
                this.map.put(slave);
                continue;
            }
            this.holder.write(slave);
            this.nullableRecord.set_null(this.map.get(master) == null);
            return this.record;
        }
        this.nullableRecord.set_null(this.map.get(master) == null);
        return this.record;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("AsOfPartitionedJoinRecordSource").put(',');
        sink.putQuoted("master").put(':').put(this.master).put(',');
        sink.putQuoted("slave").put(':').put(this.slave).put(',');
        sink.putQuoted("masterTsIndex").put(':').put(this.masterTimestampIndex).put(',');
        sink.putQuoted("slaveTsIndex").put(':').put(this.slaveTimestampIndex);
        sink.put('}');
    }
}

