/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.NullableRecord;
import com.questdb.ql.RecordSource;
import com.questdb.ql.SplitRecordMetadata;
import com.questdb.ql.join.SplitRecord;
import com.questdb.ql.join.SplitRecordStorageFacade;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.std.Misc;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;

public class CrossJoinRecordSource
extends AbstractCombinedRecordSource {
    private final RecordSource masterSource;
    private final RecordSource slaveSource;
    private final SplitRecordMetadata metadata;
    private final SplitRecord record;
    private final SplitRecordStorageFacade storageFacade;
    private final NullableRecord nullableRecord;
    private final int split;
    private RecordCursor masterCursor;
    private RecordCursor slaveCursor;
    private boolean nextSlave = false;

    public CrossJoinRecordSource(RecordSource masterSource, RecordSource slaveSource) {
        this.masterSource = masterSource;
        this.slaveSource = slaveSource;
        this.metadata = new SplitRecordMetadata(masterSource.getMetadata(), slaveSource.getMetadata());
        this.split = masterSource.getMetadata().getColumnCount();
        this.nullableRecord = new NullableRecord(slaveSource.getRecord());
        this.record = new SplitRecord(this.split, slaveSource.getMetadata().getColumnCount(), masterSource.getRecord(), this.nullableRecord);
        this.storageFacade = new SplitRecordStorageFacade(this.split);
    }

    @Override
    public void close() {
        Misc.free(this.masterSource);
        Misc.free(this.slaveSource);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.nextSlave = false;
        this.masterCursor = this.masterSource.prepareCursor(factory, cancellationHandler);
        this.slaveCursor = this.slaveSource.prepareCursor(factory, cancellationHandler);
        this.storageFacade.prepare(this.masterCursor.getStorageFacade(), this.slaveCursor.getStorageFacade());
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new SplitRecord(this.split, this.slaveSource.getMetadata().getColumnCount(), this.masterSource.getRecord(), this.nullableRecord);
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void releaseCursor() {
        this.masterCursor.releaseCursor();
        this.slaveCursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.nextSlave = false;
        this.masterCursor.toTop();
        this.slaveCursor.toTop();
    }

    @Override
    public boolean hasNext() {
        return this.nextSlave || this.masterCursor.hasNext();
    }

    @Override
    public Record next() {
        if (!this.nextSlave) {
            this.masterCursor.next();
            this.slaveCursor.toTop();
        }
        if (this.nextSlave || this.slaveCursor.hasNext()) {
            this.nullableRecord.set_null(this.slaveCursor.next() == null);
            this.nextSlave = this.slaveCursor.hasNext();
        } else {
            this.nullableRecord.set_null(true);
            this.nextSlave = false;
        }
        return this.record;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("CrossJoinRecordSource").put(',');
        sink.putQuoted("master").put(':').put(this.masterSource).put(',');
        sink.putQuoted("slave").put(':').put(this.slaveSource);
        sink.put('}');
    }
}

