/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.NullableRecord;
import com.questdb.ql.RecordSource;
import com.questdb.ql.SplitRecordMetadata;
import com.questdb.ql.join.SplitRecord;
import com.questdb.ql.join.SplitRecordStorageFacade;
import com.questdb.ql.join.hash.FakeRecord;
import com.questdb.ql.join.hash.MultiRecordMap;
import com.questdb.ql.map.MapUtils;
import com.questdb.ql.map.MetadataTypeResolver;
import com.questdb.ql.map.RecordKeyCopier;
import com.questdb.ql.map.RecordKeyCopierCompiler;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.std.IntList;
import com.questdb.std.Misc;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;
import java.io.Closeable;

public class HashJoinRecordSource
extends AbstractCombinedRecordSource
implements Closeable {
    private static final MetadataTypeResolver.MetadataTypeResolverThreadLocal tlMetadataResolver = new MetadataTypeResolver.MetadataTypeResolverThreadLocal();
    private final RecordSource master;
    private final RecordSource slave;
    private final SplitRecordMetadata metadata;
    private final SplitRecord record;
    private final SplitRecordStorageFacade storageFacade;
    private final IntList masterColIndex;
    private final IntList slaveColIndex;
    private final FakeRecord fakeRecord = new FakeRecord();
    private final boolean byRowId;
    private final boolean outer;
    private final MultiRecordMap recordMap;
    private final NullableRecord nullableRecord;
    private final RecordKeyCopier masterCopier;
    private final RecordKeyCopier slaveCopier;
    private RecordCursor slaveCursor;
    private RecordCursor masterCursor;
    private RecordCursor hashTableCursor;

    public HashJoinRecordSource(RecordSource master, IntList masterColIndices, RecordSource slave, IntList slaveColIndices, boolean outer, int keyPageSize, int dataPageSize, int rowIdPageSize, RecordKeyCopierCompiler compiler) {
        this.master = master;
        this.slave = slave;
        RecordMetadata mrm = master.getMetadata();
        RecordMetadata srm = slave.getMetadata();
        this.metadata = new SplitRecordMetadata(mrm, srm);
        this.byRowId = slave.supportsRowIdAccess();
        this.masterColIndex = masterColIndices;
        this.slaveColIndex = slaveColIndices;
        this.recordMap = this.byRowId ? new MultiRecordMap(((MetadataTypeResolver)tlMetadataResolver.get()).of(srm, slaveColIndices), MapUtils.ROWID_RECORD_METADATA, keyPageSize, rowIdPageSize) : new MultiRecordMap(((MetadataTypeResolver)tlMetadataResolver.get()).of(srm, slaveColIndices), srm, keyPageSize, dataPageSize);
        this.nullableRecord = new NullableRecord(this.byRowId ? slave.getRecord() : this.recordMap.getRecord());
        this.record = new SplitRecord(mrm.getColumnCount(), srm.getColumnCount(), master.getRecord(), this.nullableRecord);
        this.outer = outer;
        this.storageFacade = new SplitRecordStorageFacade(mrm.getColumnCount());
        this.masterCopier = compiler.compile(mrm, masterColIndices);
        this.slaveCopier = compiler.compile(srm, slaveColIndices);
    }

    @Override
    public void close() {
        Misc.free(this.recordMap);
        Misc.free(this.master);
        Misc.free(this.slave);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.hashTableCursor = null;
        this.recordMap.clear();
        this.slaveCursor = this.slave.prepareCursor(factory, cancellationHandler);
        this.masterCursor = this.master.prepareCursor(factory, cancellationHandler);
        this.buildHashTable(cancellationHandler);
        this.recordMap.setStorageFacade(this.slaveCursor.getStorageFacade());
        this.storageFacade.prepare(this.masterCursor.getStorageFacade(), this.slaveCursor.getStorageFacade());
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new SplitRecord(this.master.getMetadata().getColumnCount(), this.slave.getMetadata().getColumnCount(), this.master.getRecord(), this.slave.getRecord());
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void releaseCursor() {
        this.recordMap.clear();
        this.slaveCursor.releaseCursor();
        this.masterCursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.slaveCursor.toTop();
        this.masterCursor.toTop();
        this.hashTableCursor = null;
    }

    @Override
    public boolean hasNext() {
        if (this.hashTableCursor != null && this.hashTableCursor.hasNext()) {
            this.advanceSlaveCursor();
            return true;
        }
        return this.hasNext0();
    }

    @Override
    public SplitRecord next() {
        return this.record;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("HashJoinRecordSource").put(',');
        sink.putQuoted("master").put(':').put(this.master).put(',');
        sink.putQuoted("slave").put(':').put(this.slave).put(',');
        sink.putQuoted("joinOn").put(':').put('[');
        sink.put('[');
        RecordMetadata mm = this.master.getMetadata();
        int n = this.masterColIndex.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sink.put(',');
            }
            sink.putQuoted(mm.getColumnQuick(this.masterColIndex.getQuick(i)).getName());
        }
        sink.put(']').put(',');
        sink.put('[');
        RecordMetadata sm = this.slave.getMetadata();
        int n2 = this.slaveColIndex.size();
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                sink.put(',');
            }
            sink.putQuoted(sm.getColumnQuick(this.slaveColIndex.getQuick(i)).getName());
        }
        sink.put("]]}");
    }

    private void advanceSlaveCursor() {
        Record rec = (Record)this.hashTableCursor.next();
        this.nullableRecord.set_null((this.byRowId ? this.slaveCursor.recordAt(rec.getLong(0)) : rec) == null);
    }

    private void buildHashTable(CancellationHandler cancellationHandler) {
        for (Record r : this.slaveCursor) {
            cancellationHandler.check();
            this.recordMap.locate(this.slaveCopier, r);
            if (this.byRowId) {
                this.recordMap.add(this.fakeRecord.of(r.getRowId()));
                continue;
            }
            this.recordMap.add(r);
        }
    }

    private boolean hasNext0() {
        while (this.masterCursor.hasNext()) {
            Record r = (Record)this.masterCursor.next();
            this.recordMap.locate(this.masterCopier, r);
            this.hashTableCursor = this.recordMap.get();
            if (this.hashTableCursor.hasNext()) {
                this.advanceSlaveCursor();
                return true;
            }
            if (!this.outer) continue;
            this.hashTableCursor = null;
            this.nullableRecord.set_null(true);
            return true;
        }
        return false;
    }
}

