/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join;

import com.questdb.common.Record;
import com.questdb.std.DirectInputStream;
import com.questdb.std.IntList;
import com.questdb.std.ObjList;
import java.io.OutputStream;

public class SplitRecord
implements Record {
    private final ObjList<Record> records = new ObjList();
    private final IntList indices = new IntList();

    SplitRecord(int countA, int countB, Record recordA, Record recordB) {
        this.addRecord(recordA, countA);
        this.addRecord(recordB, countB);
    }

    @Override
    public byte get(int col) {
        return this.getRec(col).get(this.idx(col));
    }

    @Override
    public void getBin(int col, OutputStream s) {
        this.getRec(col).getBin(this.idx(col), s);
    }

    @Override
    public DirectInputStream getBin(int col) {
        return this.getRec(col).getBin(this.idx(col));
    }

    @Override
    public long getBinLen(int col) {
        return this.getRec(col).getBinLen(this.idx(col));
    }

    @Override
    public boolean getBool(int col) {
        return this.getRec(col).getBool(this.idx(col));
    }

    @Override
    public long getDate(int col) {
        return this.getRec(col).getDate(this.idx(col));
    }

    @Override
    public double getDouble(int col) {
        return this.getRec(col).getDouble(this.idx(col));
    }

    @Override
    public float getFloat(int col) {
        return this.getRec(col).getFloat(this.idx(col));
    }

    @Override
    public CharSequence getFlyweightStr(int col) {
        return this.getRec(col).getFlyweightStr(this.idx(col));
    }

    @Override
    public CharSequence getFlyweightStrB(int col) {
        return this.getRec(col).getFlyweightStrB(this.idx(col));
    }

    @Override
    public int getInt(int col) {
        return this.getRec(col).getInt(this.idx(col));
    }

    @Override
    public long getLong(int col) {
        return this.getRec(col).getLong(this.idx(col));
    }

    @Override
    public long getRowId() {
        return -1L;
    }

    @Override
    public short getShort(int col) {
        return this.getRec(col).getShort(this.idx(col));
    }

    @Override
    public int getStrLen(int col) {
        return this.getRec(col).getStrLen(this.idx(col));
    }

    @Override
    public CharSequence getSym(int col) {
        return this.getRec(col).getSym(this.idx(col));
    }

    public Record getRec(int col) {
        return this.records.getQuick(col);
    }

    private void addRecord(Record rec, int count) {
        if (rec instanceof SplitRecord) {
            ObjList<Record> theirRecords = ((SplitRecord)rec).records;
            int n = theirRecords.size();
            for (int i = 0; i < n; ++i) {
                this.records.add(theirRecords.getQuick(i));
                this.indices.add(((SplitRecord)rec).indices.getQuick(i));
            }
        } else {
            for (int i = 0; i < count; ++i) {
                this.records.add(rec);
                this.indices.add(i);
            }
        }
    }

    private int idx(int col) {
        return this.indices.getQuick(col);
    }
}

