/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join.asof;

import com.questdb.common.RecordMetadata;
import com.questdb.ql.join.asof.AbstractMemRecord;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.DirectCharSequence;

abstract class AbstractVarMemRecord
extends AbstractMemRecord {
    private final DirectCharSequence[] csA;
    private final DirectCharSequence[] csB;

    public AbstractVarMemRecord(RecordMetadata metadata) {
        int n = metadata.getColumnCount();
        DirectCharSequence[] csA = null;
        DirectCharSequence[] csB = null;
        for (int i = 0; i < n; ++i) {
            if (metadata.getColumnQuick(i).getType() != 7) continue;
            if (csA == null) {
                csA = new DirectCharSequence[n];
                csB = new DirectCharSequence[n];
            }
            csA[i] = new DirectCharSequence();
            csB[i] = new DirectCharSequence();
        }
        this.csA = csA;
        this.csB = csB;
    }

    @Override
    public CharSequence getFlyweightStr(int col) {
        long address = this.address() + (long)this.getInt(col);
        int len = Unsafe.getUnsafe().getInt(address);
        if (len == -1) {
            return null;
        }
        return Unsafe.arrayGet(this.csA, col).of(address + 4L, address + 4L + (long)(len * 2));
    }

    @Override
    public CharSequence getFlyweightStrB(int col) {
        long address = this.address() + (long)this.getInt(col);
        int len = Unsafe.getUnsafe().getInt(address);
        if (len == -1) {
            return null;
        }
        return Unsafe.arrayGet(this.csB, col).of(address + 4L, address + 4L + (long)(len * 2));
    }

    @Override
    public int getStrLen(int col) {
        return Unsafe.getUnsafe().getInt(this.address() + (long)this.getInt(col));
    }

    @Override
    public void getStr(int col, CharSink sink) {
        long address = this.address() + (long)this.getInt(col);
        long n = address + 4L + (long)(Unsafe.getUnsafe().getInt(address) * 2);
        for (long p = address + 4L; p < n; p += 2L) {
            sink.put(Unsafe.getUnsafe().getChar(p));
        }
    }

    protected abstract long address();
}

