/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join.asof;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.common.SymbolTable;
import com.questdb.ql.join.asof.AbstractMemRecord;
import com.questdb.ql.join.asof.RecordHolder;
import com.questdb.ql.join.asof.RecordUtils;
import com.questdb.std.IntList;
import com.questdb.std.Unsafe;

public class FixRecordHolder
extends AbstractMemRecord
implements RecordHolder {
    private final IntList types;
    private final IntList offsets;
    private final int size;
    private long address;
    private StorageFacade storageFacade;
    private boolean held = false;

    public FixRecordHolder(RecordMetadata metadata) {
        int cc = metadata.getColumnCount();
        this.types = new IntList(cc);
        this.offsets = new IntList(cc);
        int size = 0;
        block6: for (int i = 0; i < cc; ++i) {
            int type = metadata.getColumnQuick(i).getType();
            this.types.add(type);
            this.offsets.add(size);
            switch (type) {
                case 3: 
                case 4: 
                case 8: {
                    size += 4;
                    continue block6;
                }
                case 2: 
                case 5: 
                case 10: {
                    size += 8;
                    continue block6;
                }
                case 0: 
                case 1: {
                    ++size;
                    continue block6;
                }
                case 6: {
                    size += 2;
                    continue block6;
                }
            }
        }
        this.size = size;
        this.address = Unsafe.malloc(this.size);
    }

    @Override
    public void clear() {
        this.held = false;
    }

    @Override
    public Record peek() {
        return this.held ? this : null;
    }

    @Override
    public void setCursor(RecordCursor cursor) {
        this.storageFacade = cursor.getStorageFacade();
    }

    @Override
    public void write(Record record) {
        this.held = true;
        int n = this.types.size();
        for (int i = 0; i < n; ++i) {
            RecordUtils.copyFixed(this.types.getQuick(i), record, i, this.address + (long)this.offsets.getQuick(i));
        }
    }

    @Override
    public void close() {
        if (this.address != 0L) {
            Unsafe.free(this.address, this.size);
            this.address = 0L;
        }
    }

    @Override
    protected long address(int col) {
        return this.address + (long)this.offsets.getQuick(col);
    }

    @Override
    protected SymbolTable getSymbolTable(int col) {
        return this.storageFacade.getSymbolTable(col);
    }
}

