/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join.asof;

import com.questdb.std.IntList;
import com.questdb.std.LongList;

public class FreeList {
    private final IntList sizes = new IntList();
    private final LongList offsets = new LongList();
    private int maxSize = -1;
    private long totalSize = 0L;

    public void add(long offset, int size) {
        int index = this.sizes.binarySearch(size);
        if (index < 0) {
            index = -(index + 1);
        }
        this.sizes.add(index, size);
        this.offsets.add(index, offset);
        if (size > this.maxSize) {
            this.maxSize = size;
        }
        this.totalSize += (long)size;
    }

    public void clear() {
        this.totalSize = 0L;
        this.maxSize = -1;
        this.sizes.clear();
        this.offsets.clear();
    }

    public long findAndRemove(int size) {
        if (size > this.maxSize) {
            return -1L;
        }
        int index = this.sizes.binarySearch(size);
        if (index < 0 && (index = -(index + 1)) == this.sizes.size()) {
            this.maxSize = index > 0 ? this.sizes.getQuick(index - 1) : -1;
            return -1L;
        }
        long offset = this.offsets.getQuick(index);
        this.offsets.removeIndex(index);
        this.totalSize -= (long)this.sizes.getQuick(index);
        this.sizes.removeIndex(index);
        return offset;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public String toString() {
        return "FreeList{sizes=" + this.sizes + ", offsets=" + this.offsets + ", maxSize=" + this.maxSize + '}';
    }
}

