/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join.asof;

import com.questdb.common.ColumnType;
import com.questdb.common.JournalRuntimeException;
import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.common.SymbolTable;
import com.questdb.ql.join.asof.AbstractMemRecord;
import com.questdb.ql.join.asof.LastRecordMap;
import com.questdb.ql.join.asof.RecordUtils;
import com.questdb.ql.map.ColumnTypeResolver;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.LongResolver;
import com.questdb.ql.map.RecordKeyCopier;
import com.questdb.std.IntList;
import com.questdb.std.LongList;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;

public class LastFixRecordMap
implements LastRecordMap {
    private final DirectMap map;
    private final LongList pages = new LongList();
    private final int pageSize;
    private final IntList slaveValueIndexes;
    private final IntList slaveValueTypes;
    private final IntList fixedOffsets;
    private final int recordLen;
    private final RecordMetadata metadata;
    private final MapRecord record = new MapRecord();
    private final int bits;
    private final int mask;
    private final RecordKeyCopier masterCopier;
    private final RecordKeyCopier slaveCopier;
    private StorageFacade storageFacade;
    private long appendOffset;

    public LastFixRecordMap(ColumnTypeResolver masterResolver, RecordMetadata slaveMetadata, RecordKeyCopier masterCopier, RecordKeyCopier slaveCopier, int dataPageSize, int offsetPageSize) {
        this.pageSize = Numbers.ceilPow2(dataPageSize);
        this.bits = Numbers.msb(this.pageSize);
        this.mask = this.pageSize - 1;
        this.masterCopier = masterCopier;
        this.slaveCopier = slaveCopier;
        this.fixedOffsets = new IntList();
        this.slaveValueIndexes = new IntList();
        this.slaveValueTypes = new IntList();
        int varOffset = 0;
        int n = slaveMetadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.fixedOffsets.add(varOffset);
            this.slaveValueIndexes.add(i);
            int type = slaveMetadata.getColumnQuick(i).getType();
            this.slaveValueTypes.add(type);
            varOffset += ColumnType.sizeOf(type);
        }
        if (varOffset > dataPageSize) {
            throw new JournalRuntimeException("Record size is too large", new Object[0]);
        }
        this.recordLen = varOffset;
        this.map = new DirectMap(offsetPageSize, masterResolver, LongResolver.INSTANCE);
        this.metadata = slaveMetadata;
    }

    @Override
    public void close() {
        for (int i = 0; i < this.pages.size(); ++i) {
            Unsafe.free(this.pages.getQuick(i), this.pageSize);
        }
        this.pages.clear();
        this.map.close();
    }

    @Override
    public Record get(Record master) {
        long offset;
        DirectMapValues values = this.getByMaster(master);
        if (values == null || ((offset = values.getLong(0)) & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return null;
        }
        values.putLong(0, offset | Long.MIN_VALUE);
        return this.record.of(this.pages.getQuick(this.pageIndex(offset)) + (long)this.pageOffset(offset));
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void put(Record record) {
        DirectMapValues values = this.getBySlave(record);
        if (values.isNew()) {
            this.appendRec(record, values);
        } else {
            this.writeRec(record, values.getLong(0) & Long.MAX_VALUE, values);
        }
    }

    @Override
    public void reset() {
        this.appendOffset = 0L;
        this.map.clear();
    }

    @Override
    public void setSlaveCursor(RecordCursor cursor) {
        this.storageFacade = cursor.getStorageFacade();
    }

    private void appendRec(Record record, DirectMapValues values) {
        int pgInx = this.pageIndex(this.appendOffset);
        int pgOfs = this.pageOffset(this.appendOffset);
        if (pgOfs + this.recordLen > this.pageSize) {
            pgOfs = 0;
            this.appendOffset = ++pgInx * this.pageSize;
            values.putLong(0, this.appendOffset);
        } else {
            values.putLong(0, this.appendOffset);
        }
        this.appendOffset += (long)this.recordLen;
        if (pgInx == this.pages.size()) {
            this.pages.add(Unsafe.malloc(this.pageSize));
        }
        this.writeRec0(this.pages.getQuick(pgInx) + (long)pgOfs, record);
    }

    private DirectMapValues getByMaster(Record record) {
        this.map.locate(this.masterCopier, record);
        return this.map.getValues();
    }

    private DirectMapValues getBySlave(Record record) {
        this.map.locate(this.slaveCopier, record);
        return this.map.getOrCreateValues();
    }

    private int pageIndex(long offset) {
        return (int)(offset >> this.bits);
    }

    private int pageOffset(long offset) {
        return (int)(offset & (long)this.mask);
    }

    private void writeRec(Record record, long offset, DirectMapValues values) {
        values.putLong(0, offset);
        this.writeRec0(this.pages.getQuick(this.pageIndex(offset)) + (long)this.pageOffset(offset), record);
    }

    private void writeRec0(long addr, Record record) {
        int n = this.slaveValueIndexes.size();
        for (int i = 0; i < n; ++i) {
            RecordUtils.copyFixed(this.slaveValueTypes.getQuick(i), record, this.slaveValueIndexes.getQuick(i), addr + (long)this.fixedOffsets.getQuick(i));
        }
    }

    private class MapRecord
    extends AbstractMemRecord {
        private long address;

        private MapRecord() {
        }

        @Override
        protected long address(int col) {
            return this.address + (long)LastFixRecordMap.this.fixedOffsets.getQuick(col);
        }

        @Override
        protected SymbolTable getSymbolTable(int col) {
            return LastFixRecordMap.this.storageFacade.getSymbolTable(col);
        }

        private MapRecord of(long address) {
            this.address = address;
            return this;
        }
    }
}

