/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join.asof;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.join.asof.LastRecordMap;
import com.questdb.ql.map.ColumnTypeResolver;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.LongByteResolver;
import com.questdb.ql.map.RecordKeyCopier;

public class LastRowIdRecordMap
implements LastRecordMap {
    private final DirectMap map;
    private final RecordKeyCopier masterCopier;
    private final RecordKeyCopier slaveCopier;
    private final RecordMetadata metadata;
    private final Record passThruRecord;
    private RecordCursor slaveCursor;

    public LastRowIdRecordMap(ColumnTypeResolver masterResolver, RecordMetadata slaveMetadata, RecordKeyCopier masterCopier, RecordKeyCopier slaveCopier, int pageSize, Record passThruRecord) {
        this.masterCopier = masterCopier;
        this.slaveCopier = slaveCopier;
        this.passThruRecord = passThruRecord;
        this.map = new DirectMap(pageSize, masterResolver, LongByteResolver.INSTANCE);
        this.metadata = slaveMetadata;
    }

    @Override
    public void close() {
        this.map.close();
    }

    @Override
    public Record get(Record master) {
        DirectMapValues values = this.getByMaster(master);
        if (values == null || values.get(1) == 1) {
            return null;
        }
        values.putByte(1, (byte)1);
        return this.slaveCursor.recordAt(values.getLong(0));
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Record getRecord() {
        return this.passThruRecord;
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.slaveCursor.getStorageFacade();
    }

    @Override
    public void put(Record record) {
        DirectMapValues values = this.getBySlave(record);
        values.putLong(0, record.getRowId());
        values.putByte(1, (byte)0);
    }

    @Override
    public void reset() {
        this.map.clear();
    }

    @Override
    public void setSlaveCursor(RecordCursor cursor) {
        this.slaveCursor = cursor;
    }

    private DirectMapValues getByMaster(Record record) {
        this.map.locate(this.masterCopier, record);
        return this.map.getValues();
    }

    private DirectMapValues getBySlave(Record record) {
        this.map.locate(this.slaveCopier, record);
        return this.map.getOrCreateValues();
    }
}

