/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join.asof;

import com.questdb.common.ColumnType;
import com.questdb.common.JournalRuntimeException;
import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.common.SymbolTable;
import com.questdb.ql.join.asof.AbstractVarMemRecord;
import com.questdb.ql.join.asof.FreeList;
import com.questdb.ql.join.asof.LastRecordMap;
import com.questdb.ql.map.ColumnTypeResolver;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.LongResolver;
import com.questdb.ql.map.RecordKeyCopier;
import com.questdb.std.Chars;
import com.questdb.std.IntList;
import com.questdb.std.LongList;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;

public class LastVarRecordMap
implements LastRecordMap {
    private final DirectMap map;
    private final LongList pages = new LongList();
    private final int pageSize;
    private final int maxRecordSize;
    private final IntList slaveValueIndexes;
    private final IntList varColumns = new IntList();
    private final FreeList freeList = new FreeList();
    private final IntList slaveValueTypes;
    private final IntList fixedOffsets;
    private final int varOffset;
    private final RecordMetadata metadata;
    private final MapRecord record;
    private final int bits;
    private final int mask;
    private final RecordKeyCopier masterCopier;
    private final RecordKeyCopier slaveCopier;
    private StorageFacade storageFacade;
    private long appendOffset;

    public LastVarRecordMap(ColumnTypeResolver masterResolver, RecordMetadata slaveMetadata, RecordKeyCopier masterCopier, RecordKeyCopier slaveCopier, int dataPageSize, int offsetPageSize) {
        this.pageSize = Numbers.ceilPow2(dataPageSize);
        this.masterCopier = masterCopier;
        this.slaveCopier = slaveCopier;
        this.maxRecordSize = dataPageSize - 4;
        this.bits = Numbers.msb(this.pageSize);
        this.mask = this.pageSize - 1;
        this.fixedOffsets = new IntList();
        this.slaveValueIndexes = new IntList();
        this.slaveValueTypes = new IntList();
        int varOffset = 0;
        int n = slaveMetadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.fixedOffsets.add(varOffset);
            this.slaveValueIndexes.add(i);
            int type = slaveMetadata.getColumnQuick(i).getType();
            this.slaveValueTypes.add(type);
            int size = ColumnType.sizeOf(type);
            if (size == 0) {
                this.varColumns.add(i);
                varOffset += 4;
                continue;
            }
            varOffset += size;
        }
        if (varOffset > this.maxRecordSize) {
            throw new JournalRuntimeException("Record size is too large", new Object[0]);
        }
        this.varOffset = varOffset;
        this.map = new DirectMap(offsetPageSize, masterResolver, LongResolver.INSTANCE);
        this.metadata = slaveMetadata;
        this.record = new MapRecord(slaveMetadata);
    }

    @Override
    public void close() {
        for (int i = 0; i < this.pages.size(); ++i) {
            Unsafe.free(this.pages.getQuick(i), this.pageSize);
        }
        this.pages.clear();
        this.map.close();
    }

    @Override
    public Record get(Record master) {
        long offset;
        DirectMapValues values = this.getByMaster(master);
        if (values == null || ((offset = values.getLong(0)) & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return null;
        }
        values.putLong(0, offset | Long.MIN_VALUE);
        return this.record.of(this.pages.getQuick(this.pageIndex(offset)) + (long)this.pageOffset(offset));
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void put(Record record) {
        DirectMapValues values = this.getBySlave(record);
        int size = this.varOffset;
        int n = this.varColumns.size();
        for (int i = 0; i < n; ++i) {
            size += record.getStrLen(this.varColumns.getQuick(i)) * 2 + 4;
        }
        if (size > this.maxRecordSize) {
            throw new JournalRuntimeException("Record size is too large", new Object[0]);
        }
        if (values.isNew()) {
            this.appendRec(record, size, values);
        } else {
            long offset = values.getLong(0) & Long.MAX_VALUE;
            int pgInx = this.pageIndex(offset);
            int pgOfs = this.pageOffset(offset);
            int oldSize = Unsafe.getUnsafe().getInt(this.pages.getQuick(pgInx) + (long)pgOfs);
            if (size > oldSize) {
                this.freeList.add(offset, oldSize);
                if (this.freeList.getTotalSize() < (long)this.maxRecordSize) {
                    this.appendRec(record, size, values);
                } else {
                    long _offset = this.freeList.findAndRemove(size);
                    if (_offset == -1L) {
                        this.appendRec(record, size, values);
                    } else {
                        this.writeRec(record, _offset, values);
                    }
                }
            } else {
                this.writeRec(record, offset, values);
            }
        }
    }

    @Override
    public void reset() {
        this.appendOffset = 0L;
        this.map.clear();
        this.freeList.clear();
    }

    @Override
    public void setSlaveCursor(RecordCursor cursor) {
        this.storageFacade = cursor.getStorageFacade();
    }

    private void appendRec(Record record, int sz, DirectMapValues values) {
        int size;
        int pgInx = this.pageIndex(this.appendOffset);
        int pgOfs = this.pageOffset(this.appendOffset);
        if (pgOfs + (size = sz + 4 + sz / 10) > this.pageSize) {
            pgOfs = 0;
            this.appendOffset = ++pgInx * this.pageSize;
            values.putLong(0, this.appendOffset);
        } else {
            values.putLong(0, this.appendOffset);
        }
        this.appendOffset += (long)size;
        if (pgInx == this.pages.size()) {
            this.pages.add(Unsafe.malloc(this.pageSize));
        }
        long addr = this.pages.getQuick(pgInx) + (long)pgOfs;
        Unsafe.getUnsafe().putInt(addr, size - 4);
        this.writeRec0(addr + 4L, record);
    }

    private DirectMapValues getByMaster(Record record) {
        this.map.locate(this.masterCopier, record);
        return this.map.getValues();
    }

    private DirectMapValues getBySlave(Record record) {
        this.map.locate(this.slaveCopier, record);
        return this.map.getOrCreateValues();
    }

    private int pageIndex(long offset) {
        return (int)(offset >> this.bits);
    }

    private int pageOffset(long offset) {
        return (int)(offset & (long)this.mask);
    }

    private void writeRec(Record record, long offset, DirectMapValues values) {
        values.putLong(0, offset);
        this.writeRec0(this.pages.getQuick(this.pageIndex(offset)) + (long)this.pageOffset(offset) + 4L, record);
    }

    private void writeRec0(long addr, Record record) {
        int varOffset = this.varOffset;
        int n = this.slaveValueIndexes.size();
        block10: for (int i = 0; i < n; ++i) {
            int idx = this.slaveValueIndexes.getQuick(i);
            long address = addr + (long)this.fixedOffsets.getQuick(i);
            switch (this.slaveValueTypes.getQuick(i)) {
                case 4: 
                case 8: {
                    Unsafe.getUnsafe().putInt(address, record.getInt(idx));
                    continue block10;
                }
                case 5: {
                    Unsafe.getUnsafe().putLong(address, record.getLong(idx));
                    continue block10;
                }
                case 3: {
                    Unsafe.getUnsafe().putFloat(address, record.getFloat(idx));
                    continue block10;
                }
                case 2: {
                    Unsafe.getUnsafe().putDouble(address, record.getDouble(idx));
                    continue block10;
                }
                case 0: 
                case 1: {
                    Unsafe.getUnsafe().putByte(address, record.get(idx));
                    continue block10;
                }
                case 6: {
                    Unsafe.getUnsafe().putShort(address, record.getShort(idx));
                    continue block10;
                }
                case 10: {
                    Unsafe.getUnsafe().putLong(address, record.getDate(idx));
                    continue block10;
                }
                case 7: {
                    Unsafe.getUnsafe().putInt(address, varOffset);
                    CharSequence cs = record.getFlyweightStr(idx);
                    if (cs == null) {
                        Unsafe.getUnsafe().putInt(addr + (long)varOffset, -1);
                        varOffset += 4;
                        continue block10;
                    }
                    varOffset += Chars.strcpyw(record.getFlyweightStr(idx), addr + (long)varOffset);
                    continue block10;
                }
            }
        }
    }

    private class MapRecord
    extends AbstractVarMemRecord {
        private long address;

        public MapRecord(RecordMetadata metadata) {
            super(metadata);
        }

        @Override
        protected long address(int col) {
            return this.address + (long)LastVarRecordMap.this.fixedOffsets.getQuick(col);
        }

        @Override
        protected SymbolTable getSymbolTable(int col) {
            return LastVarRecordMap.this.storageFacade.getSymbolTable(col);
        }

        @Override
        protected long address() {
            return this.address;
        }

        private MapRecord of(long address) {
            this.address = address + 4L;
            return this;
        }
    }
}

