/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join.asof;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.common.SymbolTable;
import com.questdb.ql.join.asof.AbstractVarMemRecord;
import com.questdb.ql.join.asof.RecordHolder;
import com.questdb.std.Chars;
import com.questdb.std.IntList;
import com.questdb.std.Unsafe;

public class VarRecordHolder
extends AbstractVarMemRecord
implements RecordHolder {
    private final IntList types;
    private final IntList offsets;
    private final IntList strCols;
    private final int varOffset;
    private long address = 0L;
    private int size = 0;
    private StorageFacade storageFacade;
    private boolean held = false;

    public VarRecordHolder(RecordMetadata metadata) {
        super(metadata);
        int cc = metadata.getColumnCount();
        this.types = new IntList(cc);
        this.offsets = new IntList(cc);
        this.strCols = new IntList(cc);
        int offset = 0;
        block6: for (int i = 0; i < cc; ++i) {
            int type = metadata.getColumnQuick(i).getType();
            this.types.add(type);
            this.offsets.add(offset);
            switch (type) {
                case 3: 
                case 4: 
                case 8: {
                    offset += 4;
                    continue block6;
                }
                case 2: 
                case 5: 
                case 10: {
                    offset += 8;
                    continue block6;
                }
                case 0: 
                case 1: {
                    ++offset;
                    continue block6;
                }
                case 6: {
                    offset += 2;
                    continue block6;
                }
                default: {
                    this.strCols.add(i);
                    offset += 4;
                }
            }
        }
        this.varOffset = offset;
    }

    @Override
    public void clear() {
        this.held = false;
    }

    @Override
    public Record peek() {
        return this.held ? this : null;
    }

    @Override
    public void setCursor(RecordCursor cursor) {
        this.storageFacade = cursor.getStorageFacade();
    }

    @Override
    public void write(Record record) {
        this.held = true;
        int sz = this.varOffset;
        int n = this.strCols.size();
        for (int i = 0; i < n; ++i) {
            sz += record.getStrLen(this.strCols.getQuick(i)) * 2 + 4;
        }
        if (sz > this.size) {
            this.alloc(sz);
        }
        int varOffset = this.varOffset;
        int n2 = this.types.size();
        block11: for (int i = 0; i < n2; ++i) {
            long address = this.address + (long)this.offsets.getQuick(i);
            switch (this.types.getQuick(i)) {
                case 4: 
                case 8: {
                    Unsafe.getUnsafe().putInt(address, record.getInt(i));
                    continue block11;
                }
                case 5: {
                    Unsafe.getUnsafe().putLong(address, record.getLong(i));
                    continue block11;
                }
                case 3: {
                    Unsafe.getUnsafe().putFloat(address, record.getFloat(i));
                    continue block11;
                }
                case 2: {
                    Unsafe.getUnsafe().putDouble(address, record.getDouble(i));
                    continue block11;
                }
                case 0: 
                case 1: {
                    Unsafe.getUnsafe().putByte(address, record.get(i));
                    continue block11;
                }
                case 6: {
                    Unsafe.getUnsafe().putShort(address, record.getShort(i));
                    continue block11;
                }
                case 10: {
                    Unsafe.getUnsafe().putLong(address, record.getDate(i));
                    continue block11;
                }
                case 7: {
                    Unsafe.getUnsafe().putInt(address, varOffset);
                    CharSequence cs = record.getFlyweightStr(i);
                    if (cs == null) {
                        Unsafe.getUnsafe().putInt(this.address + (long)varOffset, -1);
                        varOffset += 4;
                        continue block11;
                    }
                    varOffset += Chars.strcpyw(cs, this.address + (long)varOffset);
                    continue block11;
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.address != 0L) {
            Unsafe.free(this.address, this.size);
            this.address = 0L;
            this.size = 0;
        }
    }

    @Override
    protected long address() {
        return this.address;
    }

    @Override
    protected long address(int col) {
        return this.address + (long)this.offsets.getQuick(col);
    }

    @Override
    protected SymbolTable getSymbolTable(int col) {
        return this.storageFacade.getSymbolTable(col);
    }

    private void alloc(int size) {
        if (this.address != 0L) {
            Unsafe.free(this.address, this.size);
        }
        this.address = Unsafe.malloc(size);
        this.size = size;
    }
}

