/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join.hash;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.RecordList;
import com.questdb.ql.map.ColumnTypeResolver;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.RecordKeyCopier;
import com.questdb.std.Mutable;
import java.io.Closeable;
import java.io.IOException;

public class MultiRecordMap
implements Closeable,
Mutable {
    private static final ColumnTypeResolver VALUE_RESOLVER = new ColumnTypeResolver(){

        @Override
        public int count() {
            return 2;
        }

        @Override
        public int getColumnType(int index) {
            assert (index < 2);
            return 5;
        }
    };
    private final DirectMap map;
    private final RecordList records;

    public MultiRecordMap(ColumnTypeResolver keyResolver, RecordMetadata valueMetadata, int keyPageSize, int valuePageSize) {
        this.map = new DirectMap(keyPageSize, keyResolver, VALUE_RESOLVER);
        this.records = new RecordList(valueMetadata, valuePageSize);
    }

    public void add(Record record) {
        DirectMapValues values = this.map.getOrCreateValues();
        if (values.isNew()) {
            long offset = this.records.append(record, -1L);
            values.putLong(0, offset);
            values.putLong(1, offset);
        } else {
            values.putLong(1, this.records.append(record, values.getLong(1)));
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.records.clear();
    }

    @Override
    public void close() throws IOException {
        this.map.close();
        this.records.close();
    }

    public RecordCursor get() {
        DirectMapValues values = this.map.getValues();
        this.records.of(values == null ? -1L : values.getLong(0));
        return this.records;
    }

    public Record getRecord() {
        return this.records.getRecord();
    }

    public void locate(RecordKeyCopier copier, Record record) {
        this.map.locate(copier, record);
    }

    public void setStorageFacade(StorageFacade storageFacade) {
        this.records.setStorageFacade(storageFacade);
    }
}

