/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.lambda;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.StorageFacade;
import com.questdb.common.SymbolTable;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.JournalRecord;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.RecordSource;
import com.questdb.ql.RowCursor;
import com.questdb.ql.RowSource;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.IntHashSet;
import com.questdb.std.LongList;
import com.questdb.std.ex.JournalException;
import com.questdb.store.IndexCursor;
import com.questdb.store.KVIndex;
import com.questdb.store.Partition;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

abstract class KvIndexSymLambdaHeadRowSource
implements RowSource,
RowCursor {
    protected final RecordSource recordSource;
    protected final String column;
    private final VirtualColumn filter;
    private final int recordSourceColumn;
    private final IntHashSet keys = new IntHashSet();
    private final LongList rows = new LongList();
    private final JournalRecord rec = new JournalRecord();
    private int columnIndex;
    private int cursor;

    KvIndexSymLambdaHeadRowSource(String column, RecordSource recordSource, int recordSourceColumn, VirtualColumn filter) {
        this.column = column;
        this.recordSource = recordSource;
        this.recordSourceColumn = recordSourceColumn;
        this.filter = filter;
    }

    @Override
    public void configure(JournalMetadata metadata) {
        this.columnIndex = metadata.getColumnIndex(this.column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(ReaderFactory factory, StorageFacade fa, CancellationHandler cancellationHandler) {
        if (this.filter != null) {
            this.filter.prepare(fa);
        }
        SymbolTable tab = fa.getSymbolTable(this.columnIndex);
        this.keys.clear();
        RecordCursor cursor = this.recordSource.prepareCursor(factory, cancellationHandler);
        try {
            for (Record r : cursor) {
                int k = tab.getQuick(this.getKey(r, this.recordSourceColumn));
                if (k <= -1) continue;
                this.keys.add(k);
            }
        }
        finally {
            cursor.releaseCursor();
        }
    }

    @Override
    public RowCursor prepareCursor(PartitionSlice slice) {
        try {
            Partition partition = this.rec.partition = slice.partition.open();
            KVIndex index = partition.getIndexForColumn(this.columnIndex);
            long lo = slice.lo - 1L;
            long hi = slice.calcHi ? partition.size() : slice.hi + 1L;
            this.rows.clear();
            int n = this.keys.size();
            block2: for (int i = 0; i < n; ++i) {
                IndexCursor c = index.cursor(this.keys.get(i));
                while (c.hasNext()) {
                    this.rec.rowid = c.next();
                    long r = this.rec.rowid;
                    if (r <= lo || r >= hi || this.filter != null && !this.filter.getBool(this.rec)) continue;
                    this.rows.add(r);
                    continue block2;
                }
            }
            this.rows.sort();
            this.cursor = 0;
            return this;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    @Override
    public void toTop() {
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.rows.size();
    }

    @Override
    public long next() {
        this.rec.rowid = this.rows.getQuick(this.cursor++);
        return this.rec.rowid;
    }

    protected abstract CharSequence getKey(Record var1, int var2);
}

