/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.latest;

import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.RowCursor;
import com.questdb.ql.RowSource;
import com.questdb.std.IntLongPriorityQueue;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

public class HeapMergingRowSource
implements RowSource,
RowCursor {
    private final RowSource[] sources;
    private final RowCursor[] cursors;
    private final IntLongPriorityQueue heap;

    public HeapMergingRowSource(RowSource ... sources) {
        this.sources = sources;
        this.cursors = new RowCursor[sources.length];
        this.heap = new IntLongPriorityQueue(sources.length);
    }

    @Override
    public void configure(JournalMetadata metadata) {
        int n = this.sources.length;
        for (int i = 0; i < n; ++i) {
            Unsafe.arrayGet(this.sources, i).configure(metadata);
        }
    }

    @Override
    public void prepare(ReaderFactory factory, StorageFacade facade, CancellationHandler cancellationHandler) {
        int n = this.sources.length;
        for (int i = 0; i < n; ++i) {
            Unsafe.arrayGet(this.sources, i).prepare(factory, facade, cancellationHandler);
        }
    }

    @Override
    public RowCursor prepareCursor(PartitionSlice slice) {
        this.heap.clear();
        int n = this.sources.length;
        for (int i = 0; i < n; ++i) {
            RowCursor c = Unsafe.arrayGet(this.sources, i).prepareCursor(slice);
            Unsafe.arrayPut(this.cursors, i, c);
            if (!c.hasNext()) continue;
            this.heap.add(i, c.next());
        }
        return this;
    }

    @Override
    public void toTop() {
        for (RowSource src : this.sources) {
            src.toTop();
        }
    }

    @Override
    public boolean hasNext() {
        return this.heap.hasNext();
    }

    @Override
    public long next() {
        int idx = this.heap.popIndex();
        return Unsafe.arrayGet(this.cursors, idx).hasNext() ? this.heap.popAndReplace(idx, Unsafe.arrayGet(this.cursors, idx).next()) : this.heap.popValue();
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("HeapMergingRowSource").put(',');
        sink.putQuoted("src").put(':').put('[');
        int n = this.sources.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sink.put(',');
            }
            sink.put(this.sources[i]);
        }
        sink.put(']');
        sink.put('}');
    }
}

