/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.latest;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.JournalRecord;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.RowCursor;
import com.questdb.ql.RowSource;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.IntHashSet;
import com.questdb.std.LongList;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.CharSink;
import com.questdb.store.FixedColumn;
import com.questdb.store.IndexCursor;
import com.questdb.store.KVIndex;
import com.questdb.store.Partition;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

public class KvIndexIntListHeadRowSource
implements RowSource,
RowCursor {
    private final String column;
    private final VirtualColumn filter;
    private final IntHashSet values;
    private final LongList rows = new LongList();
    private final JournalRecord rec = new JournalRecord();
    private int keyIndex;
    private int buckets;
    private int columnIndex;

    public KvIndexIntListHeadRowSource(String column, IntHashSet values, VirtualColumn filter) {
        this.column = column;
        this.values = values;
        this.filter = filter;
    }

    @Override
    public void configure(JournalMetadata metadata) {
        this.columnIndex = metadata.getColumnIndex(this.column);
        this.buckets = metadata.getColumnQuick((int)this.columnIndex).distinctCountHint;
    }

    @Override
    public void prepare(ReaderFactory factory, StorageFacade storageFacade, CancellationHandler cancellationHandler) {
        if (this.filter != null) {
            this.filter.prepare(storageFacade);
        }
    }

    @Override
    public RowCursor prepareCursor(PartitionSlice slice) {
        try {
            Partition partition = this.rec.partition = slice.partition.open();
            KVIndex index = partition.getIndexForColumn(this.columnIndex);
            FixedColumn col = partition.fixCol(this.columnIndex);
            long lo = slice.lo - 1L;
            long hi = slice.calcHi ? partition.size() : slice.hi + 1L;
            this.rows.clear();
            int n = this.values.size();
            for (int i = 0; i < n; ++i) {
                IndexCursor c = index.cursor(this.values.get(i) & this.buckets);
                long r = -1L;
                boolean found = false;
                while (c.hasNext()) {
                    this.rec.rowid = c.next();
                    r = this.rec.rowid;
                    if (r <= lo || r >= hi || col.getInt(r) != this.values.get(i) || this.filter != null && !this.filter.getBool(this.rec)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                this.rows.add(r);
            }
            this.rows.sort();
            this.keyIndex = 0;
            return this;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    @Override
    public void toTop() {
    }

    @Override
    public boolean hasNext() {
        return this.keyIndex < this.rows.size();
    }

    @Override
    public long next() {
        this.rec.rowid = this.rows.getQuick(this.keyIndex++);
        return this.rec.rowid;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("KvIndexIntListHeadRowSource").put(',');
        sink.putQuoted("column").put(':').putQuoted(this.column);
        sink.put('}');
    }
}

