/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.latest;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.RowCursor;
import com.questdb.ql.RowSource;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.CharSink;
import com.questdb.store.FixedColumn;
import com.questdb.store.IndexCursor;
import com.questdb.store.KVIndex;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

public class KvIndexIntLookupRowSource
implements RowSource,
RowCursor {
    private final String columnName;
    private final boolean newCursor;
    private final int value;
    private int columnIndex;
    private int key = -2;
    private IndexCursor indexCursor;
    private long lo;
    private long hi;
    private long rowid;
    private boolean hasNext = false;
    private FixedColumn column;

    public KvIndexIntLookupRowSource(String columnName, int value) {
        this(columnName, value, false);
    }

    public KvIndexIntLookupRowSource(String columnName, int value, boolean newCursor) {
        this.columnName = columnName;
        this.newCursor = newCursor;
        this.value = value;
    }

    @Override
    public void configure(JournalMetadata metadata) {
        this.columnIndex = metadata.getColumnIndex(this.columnName);
        this.key = this.value & metadata.getColumnQuick((int)this.columnIndex).distinctCountHint;
    }

    @Override
    public void prepare(ReaderFactory factory, StorageFacade storageFacade, CancellationHandler cancellationHandler) {
    }

    @Override
    public RowCursor prepareCursor(PartitionSlice slice) {
        try {
            this.column = slice.partition.fixCol(this.columnIndex);
            KVIndex index = slice.partition.getIndexForColumn(this.columnIndex);
            this.indexCursor = this.newCursor ? index.newFwdCursor(this.key) : index.fwdCursor(this.key);
            this.lo = slice.lo - 1L;
            this.hi = slice.calcHi ? slice.partition.open().size() : slice.hi + 1L;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
        return this;
    }

    @Override
    public void toTop() {
        this.indexCursor = null;
        this.hasNext = false;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            return true;
        }
        if (this.indexCursor != null) {
            while (this.indexCursor.hasNext()) {
                long r = this.indexCursor.next();
                if (r <= this.lo || r >= this.hi || this.column.getInt(r) != this.value) continue;
                this.rowid = r;
                this.hasNext = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public long next() {
        this.hasNext = false;
        return this.rowid;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("KvIndexIntLookupRowSource").put(',');
        sink.putQuoted("column").put(':').putQuoted(this.columnName);
        sink.putQuoted("value").put(':').put(this.value);
        sink.put('}');
    }
}

