/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.latest;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.RowCursor;
import com.questdb.ql.RowSource;
import com.questdb.std.Hash;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.CharSink;
import com.questdb.store.IndexCursor;
import com.questdb.store.KVIndex;
import com.questdb.store.VariableColumn;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

public class KvIndexStrLookupRowSource
implements RowSource,
RowCursor {
    private final String columnName;
    private final String value;
    private final boolean newCursor;
    private int hash;
    private IndexCursor indexCursor;
    private long lo;
    private long hi;
    private long rowid;
    private VariableColumn column;
    private int columnIndex;
    private boolean hasNext = false;

    public KvIndexStrLookupRowSource(String columnName, String value) {
        this(columnName, value, false);
    }

    public KvIndexStrLookupRowSource(String columnName, String value, boolean newCursor) {
        this.columnName = columnName;
        this.value = value;
        this.newCursor = newCursor;
    }

    @Override
    public void configure(JournalMetadata metadata) {
        this.columnIndex = metadata.getColumnIndex(this.columnName);
        this.hash = Hash.boundedHash(this.value, metadata.getColumnQuick((int)this.columnIndex).distinctCountHint);
    }

    @Override
    public void prepare(ReaderFactory factory, StorageFacade storageFacade, CancellationHandler cancellationHandler) {
    }

    @Override
    public RowCursor prepareCursor(PartitionSlice slice) {
        try {
            this.column = slice.partition.varCol(this.columnIndex);
            KVIndex index = slice.partition.getIndexForColumn(this.columnIndex);
            this.indexCursor = this.newCursor ? index.newFwdCursor(this.hash) : index.fwdCursor(this.hash);
            this.lo = slice.lo - 1L;
            this.hi = slice.calcHi ? slice.partition.open().size() : slice.hi + 1L;
            this.hasNext = false;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
        return this;
    }

    @Override
    public void toTop() {
        this.indexCursor = null;
        this.hasNext = false;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            return true;
        }
        if (this.indexCursor != null) {
            while (this.indexCursor.hasNext()) {
                long r = this.indexCursor.next();
                if (r <= this.lo || r >= this.hi || !this.column.cmpStr(r, this.value)) continue;
                this.rowid = r;
                this.hasNext = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public long next() {
        this.hasNext = false;
        return this.rowid;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("KvIndexStrLookupRowSource").put(',');
        sink.putQuoted("column").put(':').putQuoted(this.columnName).put(',');
        sink.putQuoted("value").put(':').putQuoted(this.value);
        sink.put('}');
    }
}

