/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.latest;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.JournalRecord;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.RowCursor;
import com.questdb.ql.RowSource;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.LongList;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.CharSink;
import com.questdb.store.IndexCursor;
import com.questdb.store.KVIndex;
import com.questdb.store.Partition;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

public class KvIndexSymAllHeadRowSource
implements RowSource,
RowCursor {
    private final String column;
    private final VirtualColumn filter;
    private final LongList rows = new LongList();
    private final JournalRecord rec = new JournalRecord();
    private int cursor;
    private int valueCount;
    private int columnIndex;

    public KvIndexSymAllHeadRowSource(String column, VirtualColumn filter) {
        this.column = column;
        this.filter = filter;
    }

    @Override
    public void configure(JournalMetadata metadata) {
        this.columnIndex = metadata.getColumnIndex(this.column);
    }

    @Override
    public void prepare(ReaderFactory factory, StorageFacade facade, CancellationHandler cancellationHandler) {
        if (this.filter != null) {
            this.filter.prepare(facade);
        }
        this.valueCount = facade.getSymbolTable(this.columnIndex).size();
    }

    @Override
    public RowCursor prepareCursor(PartitionSlice slice) {
        try {
            Partition partition = this.rec.partition = slice.partition.open();
            KVIndex index = partition.getIndexForColumn(this.columnIndex);
            long lo = slice.lo - 1L;
            long hi = slice.calcHi ? partition.size() : slice.hi + 1L;
            this.rows.clear();
            int n = this.valueCount;
            block2: for (int i = 0; i < n; ++i) {
                IndexCursor c = index.cursor(i);
                while (c.hasNext()) {
                    this.rec.rowid = c.next();
                    long r = this.rec.rowid;
                    if (r <= lo || r >= hi || this.filter != null && !this.filter.getBool(this.rec)) continue;
                    this.rows.add(r);
                    continue block2;
                }
            }
            this.rows.sort();
            this.cursor = 0;
            return this;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    @Override
    public void toTop() {
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.rows.size();
    }

    @Override
    public long next() {
        this.rec.rowid = this.rows.get(this.cursor++);
        return this.rec.rowid;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("KvIndexSymAllHeadRowSource").put(',');
        sink.putQuoted("column").put(':').putQuoted(this.column);
        sink.put('}');
    }
}

