/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.latest;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.StorageFacade;
import com.questdb.common.SymbolTable;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.JournalRecord;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.RowCursor;
import com.questdb.ql.RowSource;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.IntList;
import com.questdb.std.LongList;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.CharSink;
import com.questdb.store.IndexCursor;
import com.questdb.store.KVIndex;
import com.questdb.store.Partition;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

public class KvIndexSymListHeadRowSource
implements RowSource,
RowCursor {
    private final String column;
    private final VirtualColumn filter;
    private final CharSequenceHashSet values;
    private final IntList keys = new IntList();
    private final LongList rows = new LongList();
    private final JournalRecord rec = new JournalRecord();
    private int columnIndex;
    private int keyIndex;

    public KvIndexSymListHeadRowSource(String column, CharSequenceHashSet values, VirtualColumn filter) {
        this.column = column;
        this.values = values;
        this.filter = filter;
    }

    @Override
    public void configure(JournalMetadata metadata) {
        this.columnIndex = metadata.getColumnIndex(this.column);
    }

    @Override
    public void prepare(ReaderFactory factory, StorageFacade fa, CancellationHandler cancellationHandler) {
        if (this.filter != null) {
            this.filter.prepare(fa);
        }
        SymbolTable tab = fa.getSymbolTable(this.columnIndex);
        this.keys.clear();
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            int k = tab.getQuick(this.values.get(i));
            if (k <= -1) continue;
            this.keys.add(k);
        }
    }

    @Override
    public RowCursor prepareCursor(PartitionSlice slice) {
        try {
            Partition partition = this.rec.partition = slice.partition.open();
            KVIndex index = partition.getIndexForColumn(this.columnIndex);
            long lo = slice.lo - 1L;
            long hi = slice.calcHi ? partition.size() : slice.hi + 1L;
            this.rows.clear();
            int n = this.keys.size();
            for (int i = 0; i < n; ++i) {
                IndexCursor c = index.cursor(this.keys.getQuick(i));
                long r = -1L;
                boolean found = false;
                while (c.hasNext()) {
                    this.rec.rowid = c.next();
                    r = this.rec.rowid;
                    if (r <= lo || r >= hi || this.filter != null && !this.filter.getBool(this.rec)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                this.rows.add(r);
            }
            this.rows.sort();
            this.keyIndex = 0;
            return this;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    @Override
    public void toTop() {
    }

    @Override
    public boolean hasNext() {
        return this.keyIndex < this.rows.size();
    }

    @Override
    public long next() {
        this.rec.rowid = this.rows.getQuick(this.keyIndex++);
        return this.rec.rowid;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("KvIndexSymListHeadRowSource").put(',');
        sink.putQuoted("column").put(':').put(this.column);
        sink.put('}');
    }
}

