/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.latest;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.RowCursor;
import com.questdb.ql.RowSource;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.CharSink;
import com.questdb.store.IndexCursor;
import com.questdb.store.KVIndex;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

public class KvIndexSymLookupRowSource
implements RowSource,
RowCursor {
    private final String symbol;
    private final String value;
    private final boolean newCursor;
    private int columnIndex;
    private int symbolKey = -2;
    private IndexCursor indexCursor;
    private long lo;
    private long hi;
    private boolean full;
    private long rowid;
    private boolean hasNext = false;

    public KvIndexSymLookupRowSource(String symbol, String value) {
        this(symbol, value, false);
    }

    public KvIndexSymLookupRowSource(String symbol, String value, boolean newCursor) {
        this.symbol = symbol;
        this.value = value;
        this.newCursor = newCursor;
    }

    @Override
    public void configure(JournalMetadata metadata) {
        this.columnIndex = metadata.getColumnIndex(this.symbol);
    }

    @Override
    public void prepare(ReaderFactory factory, StorageFacade facade, CancellationHandler cancellationHandler) {
        this.symbolKey = facade.getSymbolTable(this.columnIndex).getQuick(this.value);
    }

    @Override
    public RowCursor prepareCursor(PartitionSlice slice) {
        try {
            KVIndex index = slice.partition.getIndexForColumn(this.columnIndex);
            this.indexCursor = this.newCursor ? index.newFwdCursor(this.symbolKey) : index.fwdCursor(this.symbolKey);
            this.full = slice.lo == 0L && slice.calcHi;
            this.lo = slice.lo - 1L;
            this.hi = slice.calcHi ? slice.partition.open().size() : slice.hi + 1L;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
        return this;
    }

    @Override
    public void toTop() {
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            return true;
        }
        if (this.indexCursor != null && this.indexCursor.hasNext()) {
            if (this.full) {
                this.rowid = this.indexCursor.next();
                this.hasNext = true;
                return true;
            }
            do {
                long rowid;
                if ((rowid = this.indexCursor.next()) <= this.lo || rowid >= this.hi) continue;
                this.rowid = rowid;
                this.hasNext = true;
                return true;
            } while (this.indexCursor.hasNext());
        }
        return false;
    }

    @Override
    public long next() {
        this.hasNext = false;
        return this.rowid;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("KvIndexSymLookupRowSource").put(',');
        sink.putQuoted("symbol").put(':').putQuoted(this.symbol).put(',');
        sink.putQuoted("value").put(':').putQuoted(this.value);
        sink.put('}');
    }
}

