/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.latest;

import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.RowCursor;
import com.questdb.ql.RowSource;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

public class MergingRowSource
implements RowSource,
RowCursor {
    private final RowSource lhs;
    private final RowSource rhs;
    private RowCursor lhc;
    private RowCursor rhc;
    private long nxtl;
    private long nxtr;

    public MergingRowSource(RowSource lhs, RowSource rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public void configure(JournalMetadata metadata) {
        this.lhs.configure(metadata);
        this.rhs.configure(metadata);
    }

    @Override
    public void prepare(ReaderFactory factory, StorageFacade facade, CancellationHandler cancellationHandler) {
        this.lhs.prepare(factory, facade, cancellationHandler);
        this.rhs.prepare(factory, facade, cancellationHandler);
    }

    @Override
    public RowCursor prepareCursor(PartitionSlice slice) {
        this.lhc = this.lhs.prepareCursor(slice);
        this.rhc = this.rhs.prepareCursor(slice);
        this.nxtl = -1L;
        this.nxtr = -1L;
        return this;
    }

    @Override
    public void toTop() {
        this.lhs.toTop();
        this.rhs.toTop();
        this.nxtl = -1L;
        this.nxtr = -1L;
    }

    @Override
    public boolean hasNext() {
        return this.nxtl > -1L || this.lhc.hasNext() || this.nxtr > -1L || this.rhc.hasNext();
    }

    @Override
    public long next() {
        long result;
        if (this.nxtl == -1L && this.lhc.hasNext()) {
            this.nxtl = this.lhc.next();
        }
        if (this.nxtr == -1L && this.rhc.hasNext()) {
            this.nxtr = this.rhc.next();
        }
        if (this.nxtr == -1L || this.nxtl > -1L && this.nxtl < this.nxtr) {
            result = this.nxtl;
            this.nxtl = -1L;
        } else {
            result = this.nxtr;
            this.nxtr = -1L;
        }
        return result;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("MergingRowSource").put(',');
        sink.putQuoted("left").put(':').put(this.lhs).put(',');
        sink.putQuoted("right").put(':').put(this.rhs);
        sink.put('}');
    }
}

