/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.map;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.Record;
import com.questdb.ql.map.ColumnTypeResolver;
import com.questdb.ql.map.DirectMapEntry;
import com.questdb.ql.map.DirectMapIterator;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.RecordKeyCopier;
import com.questdb.std.DirectInputStream;
import com.questdb.std.DirectLongList;
import com.questdb.std.Hash;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class DirectMap
implements Mutable,
Iterable<DirectMapEntry>,
Closeable {
    private static final int MIN_INITIAL_CAPACITY = 128;
    private final float loadFactor;
    private final KeyWriter keyWriter = new KeyWriter();
    private final DirectMapValues values;
    private final DirectMapIterator iterator;
    private final DirectMapEntry entry;
    private long address;
    private long capacity;
    private int keyBlockOffset;
    private int keyDataOffset;
    private DirectLongList offsets;
    private long kStart;
    private long kLimit;
    private long kPos;
    private int free;
    private int keyCapacity;
    private int size = 0;
    private int mask;

    public DirectMap(int pageSize, ColumnTypeResolver keyResolver, ColumnTypeResolver valueResolver) {
        this(64, pageSize, 0.5f, keyResolver, valueResolver);
    }

    private DirectMap(int capacity, int pageSize, float loadFactor, ColumnTypeResolver keyResolver, ColumnTypeResolver valueResolver) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize must be > 0");
        }
        this.loadFactor = loadFactor;
        this.capacity = pageSize + 64;
        this.address = Unsafe.malloc(this.capacity);
        this.kStart = this.kPos = this.address + (this.address & 0x3FL);
        this.kLimit = this.kStart + (long)pageSize;
        this.keyCapacity = (int)((float)capacity / loadFactor);
        this.keyCapacity = this.keyCapacity < 128 ? 128 : Numbers.ceilPow2(this.keyCapacity);
        this.mask = this.keyCapacity - 1;
        this.free = (int)((float)this.keyCapacity * loadFactor);
        this.offsets = new DirectLongList(this.keyCapacity);
        this.offsets.setPos(this.keyCapacity);
        this.offsets.zero(-1L);
        int columnSplit = valueResolver.count();
        int[] valueOffsets = new int[columnSplit];
        int offset = 4;
        block6: for (int i = 0; i < columnSplit; ++i) {
            valueOffsets[i] = offset++;
            switch (valueResolver.getColumnType(i)) {
                case 0: 
                case 1: {
                    continue block6;
                }
                case 6: {
                    offset += 2;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 8: {
                    offset += 4;
                    continue block6;
                }
                case 2: 
                case 5: 
                case 10: {
                    offset += 8;
                    continue block6;
                }
                default: {
                    throw new JournalRuntimeException("value type is not supported: " + valueResolver.getColumnType(i), new Object[0]);
                }
            }
        }
        this.values = new DirectMapValues(valueOffsets);
        this.keyBlockOffset = offset;
        this.keyDataOffset = this.keyBlockOffset + 4 * keyResolver.count();
        this.entry = new DirectMapEntry(valueOffsets, this.keyDataOffset, this.keyBlockOffset, this.values, keyResolver);
        this.iterator = new DirectMapIterator(this.entry);
    }

    @Override
    public void clear() {
        this.kPos = this.kStart;
        this.free = (int)((float)this.keyCapacity * this.loadFactor);
        this.size = 0;
        this.offsets.zero(-1L);
    }

    @Override
    public void close() {
        this.offsets.close();
        if (this.address != 0L) {
            Unsafe.free(this.address, this.capacity);
            this.address = 0L;
        }
    }

    public DirectMapEntry entryAt(long rowid) {
        return this.entry.init(rowid);
    }

    public DirectMapValues getOrCreateValues() {
        this.keyWriter.commit();
        int index = Hash.hashMem(this.keyWriter.startAddr + (long)this.keyDataOffset, this.keyWriter.len - this.keyDataOffset) & this.mask;
        long offset = this.offsets.get(index);
        if (offset == -1L) {
            return this.asNew(this.keyWriter, index);
        }
        if (this.eq(this.keyWriter, offset)) {
            this.kPos = this.keyWriter.startAddr;
            return this.values.of(this.kStart + offset, false);
        }
        return this.probe0(this.keyWriter, index);
    }

    public DirectMapValues getValues() {
        this.keyWriter.commit();
        this.kPos = this.keyWriter.startAddr;
        int index = Hash.hashMem(this.keyWriter.startAddr + (long)this.keyDataOffset, this.keyWriter.len - this.keyDataOffset) & this.mask;
        long offset = this.offsets.get(index);
        if (offset == -1L) {
            return null;
        }
        if (this.eq(this.keyWriter, offset)) {
            return this.values.of(this.kStart + offset, false);
        }
        return this.probeReadOnly(this.keyWriter, index);
    }

    @NotNull
    public DirectMapIterator iterator() {
        return this.iterator.init(this.kStart, this.size);
    }

    public KeyWriter keyWriter() {
        return this.keyWriter.init();
    }

    public void locate(RecordKeyCopier copier, Record record) {
        this.keyWriter.init();
        copier.copy(record, this.keyWriter);
    }

    public void locate(long rowid) {
        this.keyWriter.startAddr = this.kPos;
        this.keyWriter.appendAddr = this.keyWriter.startAddr + (long)this.keyDataOffset;
        if (this.keyWriter.appendAddr + 8L > this.kLimit) {
            this.resize();
        }
        Unsafe.getUnsafe().putLong(this.keyWriter.appendAddr, rowid);
        KeyWriter keyWriter = this.keyWriter;
        keyWriter.appendAddr = keyWriter.appendAddr + 8L;
    }

    public int size() {
        return this.size;
    }

    private DirectMapValues asNew(KeyWriter keyWriter, int index) {
        this.offsets.set(index, keyWriter.startAddr - this.kStart);
        if (--this.free == 0) {
            this.rehash();
        }
        ++this.size;
        return this.values.of(keyWriter.startAddr, true);
    }

    private boolean eq(KeyWriter keyWriter, long offset) {
        long a = this.kStart + offset;
        long b = keyWriter.startAddr;
        if (Unsafe.getUnsafe().getInt(a) != Unsafe.getUnsafe().getInt(b)) {
            return false;
        }
        long lim = b + (long)keyWriter.len;
        a += (long)this.keyDataOffset;
        b += (long)this.keyDataOffset;
        while (b < lim - 8L) {
            if (Unsafe.getUnsafe().getLong(a) != Unsafe.getUnsafe().getLong(b)) {
                return false;
            }
            a += 8L;
            b += 8L;
        }
        while (b < lim) {
            if (Unsafe.getUnsafe().getByte(a++) == Unsafe.getUnsafe().getByte(b++)) continue;
            return false;
        }
        return true;
    }

    private DirectMapValues probe0(KeyWriter keyWriter, int index) {
        block2: {
            long offset;
            do {
                ++index;
                offset = this.offsets.get(index &= this.mask);
                if (offset == -1L) break block2;
            } while (!this.eq(keyWriter, offset));
            this.kPos = keyWriter.startAddr;
            return this.values.of(this.kStart + offset, false);
        }
        this.offsets.set(index, keyWriter.startAddr - this.kStart);
        --this.free;
        if (this.free == 0) {
            this.rehash();
        }
        ++this.size;
        return this.values.of(keyWriter.startAddr, true);
    }

    private DirectMapValues probeReadOnly(KeyWriter keyWriter, int index) {
        block1: {
            long offset;
            do {
                ++index;
                offset = this.offsets.get(index &= this.mask);
                if (offset == -1L) break block1;
            } while (!this.eq(keyWriter, offset));
            return this.values.of(this.kStart + offset, false);
        }
        return null;
    }

    private void rehash() {
        int capacity = this.keyCapacity << 1;
        this.mask = capacity - 1;
        DirectLongList pointers = new DirectLongList(capacity);
        pointers.setPos(capacity);
        pointers.zero(-1L);
        int k = this.offsets.size();
        for (int i = 0; i < k; ++i) {
            long offset = this.offsets.get(i);
            if (offset == -1L) continue;
            int index = Hash.hashMem(this.kStart + offset + (long)this.keyDataOffset, Unsafe.getUnsafe().getInt(this.kStart + offset) - this.keyDataOffset) & this.mask;
            while (pointers.get(index) != -1L) {
                index = index + 1 & this.mask;
            }
            pointers.set(index, offset);
        }
        this.offsets.close();
        this.offsets = pointers;
        this.free = (int)((float)this.free + (float)(capacity - this.keyCapacity) * this.loadFactor);
        this.keyCapacity = capacity;
    }

    private void resize() {
        long kCapacity = this.kLimit - this.kStart << 1;
        long kAddress = Unsafe.malloc(kCapacity + 64L);
        long kStart = kAddress + (kAddress & 0x3FL);
        Unsafe.getUnsafe().copyMemory(this.kStart, kStart, kCapacity >> 1);
        Unsafe.free(this.address, this.capacity);
        long d = kStart - this.kStart;
        KeyWriter keyWriter = this.keyWriter;
        keyWriter.startAddr = keyWriter.startAddr + d;
        keyWriter = this.keyWriter;
        keyWriter.appendAddr = keyWriter.appendAddr + d;
        keyWriter = this.keyWriter;
        keyWriter.nextColOffset = keyWriter.nextColOffset + d;
        this.address = kAddress;
        this.kStart = kStart;
        this.kLimit = kStart + kCapacity;
    }

    public class KeyWriter {
        private long startAddr;
        private long appendAddr;
        private int len;
        private long nextColOffset;

        public void commit() {
            this.len = (int)(this.appendAddr - this.startAddr);
            Unsafe.getUnsafe().putInt(this.startAddr, this.len);
            DirectMap.this.kPos = this.appendAddr;
        }

        public KeyWriter init() {
            this.startAddr = DirectMap.this.kPos;
            this.appendAddr = this.startAddr + (long)DirectMap.this.keyDataOffset;
            this.nextColOffset = this.startAddr + (long)DirectMap.this.keyBlockOffset;
            return this;
        }

        public void put(long address, int len) {
            this.checkSize(len);
            Unsafe.getUnsafe().copyMemory(address, this.appendAddr, len);
            this.appendAddr += (long)len;
            this.writeOffset();
        }

        public void putBin(DirectInputStream stream) {
            long length = stream.size();
            this.checkSize((int)length);
            length = stream.copyTo(this.appendAddr, 0L, length);
            this.appendAddr += length;
        }

        public void putBool(boolean value) {
            this.checkSize(1);
            Unsafe.getUnsafe().putByte(this.appendAddr, (byte)(value ? 1 : 0));
            ++this.appendAddr;
            this.writeOffset();
        }

        public void putByte(byte value) {
            this.checkSize(1);
            Unsafe.getUnsafe().putByte(this.appendAddr, value);
            ++this.appendAddr;
            this.writeOffset();
        }

        public void putDouble(double value) {
            this.checkSize(8);
            Unsafe.getUnsafe().putDouble(this.appendAddr, value);
            this.appendAddr += 8L;
            this.writeOffset();
        }

        public void putFloat(float value) {
            this.checkSize(4);
            Unsafe.getUnsafe().putFloat(this.appendAddr, value);
            this.appendAddr += 4L;
            this.writeOffset();
        }

        public void putInt(int value) {
            this.checkSize(4);
            Unsafe.getUnsafe().putInt(this.appendAddr, value);
            this.appendAddr += 4L;
            this.writeOffset();
        }

        public void putLong(long value) {
            this.checkSize(8);
            Unsafe.getUnsafe().putLong(this.appendAddr, value);
            this.appendAddr += 8L;
            this.writeOffset();
        }

        public void putShort(short value) {
            this.checkSize(2);
            Unsafe.getUnsafe().putShort(this.appendAddr, value);
            this.appendAddr += 2L;
            this.writeOffset();
        }

        public void putStr(CharSequence value) {
            if (value == null) {
                this.putNull();
                return;
            }
            int len = value.length();
            this.checkSize((len << 1) + 4);
            Unsafe.getUnsafe().putInt(this.appendAddr, len);
            this.appendAddr += 4L;
            for (int i = 0; i < len; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddr + (long)(i << 1), value.charAt(i));
            }
            this.appendAddr += (long)(len << 1);
            this.writeOffset();
        }

        private void checkSize(int size) {
            if (this.appendAddr + (long)size > DirectMap.this.kLimit) {
                DirectMap.this.resize();
            }
        }

        private void putNull() {
            this.checkSize(4);
            Unsafe.getUnsafe().putInt(this.appendAddr, -1);
            this.appendAddr += 4L;
            this.writeOffset();
        }

        private void writeOffset() {
            Unsafe.getUnsafe().putInt(this.nextColOffset, (int)(this.appendAddr - this.startAddr));
            this.nextColOffset += 4L;
        }
    }
}

