/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.map;

import com.questdb.ql.map.ColumnTypeResolver;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.DirectCharSequence;

public final class DirectMapEntry {
    private final int split;
    private final int keyDataOffset;
    private final int keyBlockOffset;
    private final int[] valueOffsets;
    private final DirectCharSequence[] csA;
    private final DirectCharSequence[] csB;
    private final DirectMapValues values;
    private long address0;
    private long address1;
    private long address2;
    private char[] strBuf = null;

    DirectMapEntry(int[] valueOffsets, int keyDataOffset, int keyBlockOffset, DirectMapValues values, ColumnTypeResolver keyResolver) {
        this.split = valueOffsets.length;
        this.valueOffsets = valueOffsets;
        this.keyBlockOffset = keyBlockOffset;
        this.keyDataOffset = keyDataOffset;
        this.values = values;
        int n = keyResolver.count();
        DirectCharSequence[] csA = null;
        DirectCharSequence[] csB = null;
        for (int i = 0; i < n; ++i) {
            if (keyResolver.getColumnType(i) != 7) continue;
            if (csA == null) {
                csA = new DirectCharSequence[n + this.split];
                csB = new DirectCharSequence[n + this.split];
            }
            csA[i + this.split] = new DirectCharSequence();
            csB[i + this.split] = new DirectCharSequence();
        }
        this.csA = csA;
        this.csB = csB;
    }

    public byte get(int index) {
        return Unsafe.getUnsafe().getByte(this.address0(index));
    }

    public boolean getBool(int index) {
        return Unsafe.getBool(this.address0(index));
    }

    public long getDate(int index) {
        return Unsafe.getUnsafe().getLong(this.address0(index));
    }

    public double getDouble(int index) {
        return Unsafe.getUnsafe().getDouble(this.address0(index));
    }

    public float getFloat(int index) {
        return Unsafe.getUnsafe().getFloat(this.address0(index));
    }

    public CharSequence getFlyweightStr(int index) {
        assert (index < this.csA.length);
        return this.getFlyweightStr0(index, Unsafe.arrayGet(this.csA, index));
    }

    public CharSequence getFlyweightStrB(int index) {
        return this.getFlyweightStr0(index, Unsafe.arrayGet(this.csB, index));
    }

    public int getInt(int index) {
        return Unsafe.getUnsafe().getInt(this.address0(index));
    }

    public long getLong(int index) {
        return Unsafe.getUnsafe().getLong(this.address0(index));
    }

    public long getRowId() {
        return this.address0;
    }

    public short getShort(int index) {
        return Unsafe.getUnsafe().getShort(this.address0(index));
    }

    public String getStr(int index) {
        long address = this.address0(index);
        int len = Unsafe.getUnsafe().getInt(address);
        if (len == -1) {
            return null;
        }
        if (this.strBuf == null || this.strBuf.length < len) {
            this.strBuf = new char[len];
        }
        Unsafe.getUnsafe().copyMemory(null, address + 4L, this.strBuf, Unsafe.CHAR_OFFSET, (long)len << 1);
        return new String(this.strBuf, 0, len);
    }

    public void getStr(int index, CharSink sink) {
        long address = this.address0(index);
        int len = Unsafe.getUnsafe().getInt(address);
        address += 4L;
        for (int i = 0; i < len; ++i) {
            sink.put(Unsafe.getUnsafe().getChar(address));
            address += 2L;
        }
    }

    public int getStrLen(int index) {
        return Unsafe.getUnsafe().getInt(this.address0(index));
    }

    public DirectMapValues values() {
        return this.values.of(this.address0, false);
    }

    private long address0(int index) {
        if (index < this.split) {
            return this.address0 + (long)Unsafe.arrayGet(this.valueOffsets, index);
        }
        if (index == this.split) {
            return this.address1;
        }
        return (long)Unsafe.getUnsafe().getInt(this.address2 + (long)((index - this.split - 1) * 4)) + this.address0;
    }

    private CharSequence getFlyweightStr0(int index, DirectCharSequence cs) {
        long address = this.address0(index);
        int len = Unsafe.getUnsafe().getInt(address);
        return len == -1 ? null : cs.of(address + 4L, address + 4L + (long)(len * 2));
    }

    DirectMapEntry init(long address) {
        this.address0 = address;
        this.address1 = address + (long)this.keyDataOffset;
        this.address2 = address + (long)this.keyBlockOffset;
        return this;
    }
}

