/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.map;

import com.questdb.ql.map.DirectMapEntry;
import com.questdb.std.ImmutableIterator;
import com.questdb.std.Unsafe;

public final class DirectMapIterator
implements ImmutableIterator<DirectMapEntry> {
    private final DirectMapEntry entry;
    private int count;
    private long address;

    DirectMapIterator(DirectMapEntry entry) {
        this.entry = entry;
    }

    @Override
    public boolean hasNext() {
        return this.count > 0;
    }

    @Override
    public DirectMapEntry next() {
        long address = this.address;
        this.address = address + (long)Unsafe.getUnsafe().getInt(address);
        --this.count;
        return this.entry.init(address);
    }

    DirectMapIterator init(long address, int count) {
        this.address = address;
        this.count = count;
        return this;
    }
}

