/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.map;

import com.questdb.common.AbstractRecordMetadata;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.RecordMetadata;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.ObjHashSet;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;

public final class DirectMapMetadata
extends AbstractRecordMetadata {
    private final CharSequenceIntHashMap nameCache;
    private final int columnCount;
    private final RecordColumnMetadata[] columns;

    public DirectMapMetadata(RecordMetadata keySourceMetadata, ObjHashSet<String> keyNames, ObjList<RecordColumnMetadata> valueColumns) {
        int i;
        int split = valueColumns.size();
        this.columnCount = split + keyNames.size();
        this.nameCache = new CharSequenceIntHashMap(this.columnCount);
        this.columns = new RecordColumnMetadata[this.columnCount];
        for (i = 0; i < split; ++i) {
            this.columns[i] = valueColumns.get(i);
            this.nameCache.put(this.columns[i].getName(), i);
        }
        int sz = keyNames.size();
        for (i = 0; i < sz; ++i) {
            int index = keySourceMetadata.getColumnIndex(keyNames.get(i));
            this.columns[split + i] = keySourceMetadata.getColumnQuick(index);
            this.nameCache.put(keyNames.get(i), split + i);
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getColumnIndexQuiet(CharSequence name) {
        return this.nameCache.get(name);
    }

    @Override
    public RecordColumnMetadata getColumnQuick(int index) {
        return Unsafe.arrayGet(this.columns, index);
    }

    @Override
    public int getTimestampIndex() {
        return -1;
    }
}

