/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.map;

import com.questdb.std.Unsafe;

public final class DirectMapValues {
    private final int[] valueOffsets;
    private long address;
    private boolean _new;

    public DirectMapValues(int[] valueOffsets) {
        this.valueOffsets = valueOffsets;
    }

    public byte get(int index) {
        return Unsafe.getUnsafe().getByte(this.address0(index));
    }

    public double getDouble(int index) {
        return Unsafe.getUnsafe().getDouble(this.address0(index));
    }

    public float getFloat(int index) {
        return Unsafe.getUnsafe().getFloat(this.address0(index));
    }

    public int getInt(int index) {
        return Unsafe.getUnsafe().getInt(this.address0(index));
    }

    public long getLong(int index) {
        return Unsafe.getUnsafe().getLong(this.address0(index));
    }

    public short getShort(int index) {
        return Unsafe.getUnsafe().getShort(this.address0(index));
    }

    public boolean isNew() {
        return this._new;
    }

    public void putByte(int index, byte value) {
        Unsafe.getUnsafe().putByte(this.address0(index), value);
    }

    public void putDouble(int index, double value) {
        Unsafe.getUnsafe().putDouble(this.address0(index), value);
    }

    public void putFloat(int index, float value) {
        Unsafe.getUnsafe().putFloat(this.address0(index), value);
    }

    public void putInt(int index, int value) {
        Unsafe.getUnsafe().putInt(this.address0(index), value);
    }

    public void putLong(int index, long value) {
        Unsafe.getUnsafe().putLong(this.address0(index), value);
    }

    public void putShort(int index, short value) {
        Unsafe.getUnsafe().putShort(this.address0(index), value);
    }

    private long address0(int index) {
        return this.address + (long)Unsafe.arrayGet(this.valueOffsets, index);
    }

    DirectMapValues of(long address, boolean _new) {
        this.address = address;
        this._new = _new;
        return this;
    }
}

