/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.map;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.Record;
import com.questdb.ql.CollectionRecordMetadata;
import com.questdb.ql.LongMetadata;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.IntList;
import com.questdb.std.ObjList;

public class MapUtils {
    public static final IntList ROWID_MAP_VALUES = new IntList(1);
    public static final CollectionRecordMetadata ROWID_RECORD_METADATA = new CollectionRecordMetadata().add(LongMetadata.INSTANCE);

    private MapUtils() {
    }

    public static DirectMapValues getMapValues(DirectMap map, Record rec, ObjList<VirtualColumn> partitionBy) {
        DirectMap.KeyWriter kw = map.keyWriter();
        int n = partitionBy.size();
        for (int i = 0; i < n; ++i) {
            MapUtils.writeVirtualColumn(kw, rec, partitionBy.getQuick(i));
        }
        return map.getOrCreateValues();
    }

    private static void writeVirtualColumn(DirectMap.KeyWriter w, Record r, VirtualColumn vc) {
        switch (vc.getType()) {
            case 0: {
                w.putBool(vc.getBool(r));
                break;
            }
            case 1: {
                w.putByte(vc.get(r));
                break;
            }
            case 2: {
                w.putDouble(vc.getDouble(r));
                break;
            }
            case 4: {
                w.putInt(vc.getInt(r));
                break;
            }
            case 5: {
                w.putLong(vc.getLong(r));
                break;
            }
            case 6: {
                w.putShort(vc.getShort(r));
                break;
            }
            case 3: {
                w.putFloat(vc.getFloat(r));
                break;
            }
            case 7: {
                w.putStr(vc.getFlyweightStr(r));
                break;
            }
            case 8: {
                w.putInt(vc.getInt(r));
                break;
            }
            case 9: {
                w.putBin(vc.getBin(r));
                break;
            }
            case 10: {
                w.putLong(vc.getDate(r));
                break;
            }
            default: {
                throw new JournalRuntimeException("Unsupported type: " + vc.getType(), new Object[0]);
            }
        }
    }

    static {
        ROWID_MAP_VALUES.add(5);
    }
}

