/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops;

import com.questdb.common.ColumnType;
import com.questdb.common.Record;
import com.questdb.common.SymbolTable;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.DirectInputStream;
import com.questdb.std.str.CharSink;
import java.io.OutputStream;

public abstract class AbstractVirtualColumn
implements VirtualColumn {
    private final int columnType;
    private final int position;
    private String name;

    protected AbstractVirtualColumn(int columnType, int position) {
        this.columnType = columnType;
        this.position = position;
    }

    @Override
    public byte get(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getBin(Record rec, OutputStream s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirectInputStream getBin(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getBinLen(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBool(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getDate(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getFlyweightStr(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getFlyweightStrB(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public short getShort(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getStr(Record rec, CharSink sink) {
        sink.put(this.getFlyweightStr(rec));
    }

    @Override
    public int getStrLen(Record rec) {
        CharSequence cs = this.getFlyweightStr(rec);
        return cs == null ? -1 : cs.length();
    }

    @Override
    public CharSequence getSym(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getBucketCount() {
        return 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return null;
    }

    @Override
    public int getType() {
        return this.columnType;
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    protected static void typeError(int pos, int type) throws ParserException {
        throw QueryError.position(pos).$('\'').$(ColumnType.nameOf(type)).$("' type expected").$();
    }

    protected static void assertConstant(VirtualColumn arg) throws ParserException {
        if (!arg.isConstant()) {
            throw QueryError.$(arg.getPosition(), "Constant expected");
        }
    }
}

