/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops;

import com.questdb.common.NumericException;
import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.ops.AbstractVirtualColumn;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.time.DateFormatUtils;

public class DateInOperator
extends AbstractVirtualColumn
implements Function {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new DateInOperator(position);
    private VirtualColumn lhs;
    private long lo;
    private long hi;

    private DateInOperator(int position) {
        super(0, position);
    }

    @Override
    public boolean getBool(Record rec) {
        long date = this.lhs.getDate(rec);
        return date > this.lo && date < this.hi;
    }

    @Override
    public boolean isConstant() {
        return this.lhs.isConstant();
    }

    @Override
    public void prepare(StorageFacade facade) {
        this.lhs.prepare(facade);
    }

    @Override
    public void setArg(int pos, VirtualColumn arg) throws ParserException {
        if (pos == 0) {
            this.lhs = arg;
        } else {
            if (pos > 2) {
                throw QueryError.$(arg.getPosition(), "Too many args");
            }
            DateInOperator.assertConstant(arg);
            switch (arg.getType()) {
                case 7: {
                    try {
                        CharSequence cs = arg.getFlyweightStr(null);
                        if (cs == null) {
                            throw QueryError.$(arg.getPosition(), "Cannot be null");
                        }
                        if (pos == 1) {
                            this.lo = DateFormatUtils.parseDateTime(cs) - 1L;
                            break;
                        }
                        this.hi = DateFormatUtils.parseDateTime(cs) + 1L;
                        break;
                    }
                    catch (NumericException e) {
                        throw QueryError.$(arg.getPosition(), "Not a date");
                    }
                }
                default: {
                    DateInOperator.typeError(arg.getPosition(), 7);
                }
            }
        }
    }
}

