/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops;

import com.questdb.ql.ops.AndOperator;
import com.questdb.ql.ops.DateInOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.IntInOperator;
import com.questdb.ql.ops.LongInOperator;
import com.questdb.ql.ops.NotOperator;
import com.questdb.ql.ops.OrOperator;
import com.questdb.ql.ops.Signature;
import com.questdb.ql.ops.StrInOperator;
import com.questdb.ql.ops.SymInOperator;
import com.questdb.ql.ops.SymRegexOperator;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.ql.ops.VwapAggregator;
import com.questdb.ql.ops.conv.AtoDFunction;
import com.questdb.ql.ops.conv.AtoIFunction;
import com.questdb.ql.ops.conv.AtoSFunction;
import com.questdb.ql.ops.conv.DateToCharFunction;
import com.questdb.ql.ops.conv.DateToCharTZFunction;
import com.questdb.ql.ops.conv.DateToCharTZLocaleFunction;
import com.questdb.ql.ops.conv.DtoA4Function;
import com.questdb.ql.ops.conv.DtoLFunction;
import com.questdb.ql.ops.conv.LongToDateFunction;
import com.questdb.ql.ops.conv.StoAFunction;
import com.questdb.ql.ops.conv.SysdateFunction;
import com.questdb.ql.ops.conv.ToDateFunction;
import com.questdb.ql.ops.conv.ToDateThreeArgFunction;
import com.questdb.ql.ops.conv.ToDateTwoArgFunction;
import com.questdb.ql.ops.conv.TypeOfFunction;
import com.questdb.ql.ops.count.CountAggregator;
import com.questdb.ql.ops.count.CountDoubleAggregator;
import com.questdb.ql.ops.count.CountFloatAggregator;
import com.questdb.ql.ops.count.CountIntAggregator;
import com.questdb.ql.ops.count.CountLongAggregator;
import com.questdb.ql.ops.count.CountStrAggregator;
import com.questdb.ql.ops.count.CountSymAggregator;
import com.questdb.ql.ops.div.DivDoubleOperator;
import com.questdb.ql.ops.eq.DateEqualStrConstOperator;
import com.questdb.ql.ops.eq.DoubleEqualNanOperator;
import com.questdb.ql.ops.eq.DoubleEqualOperator;
import com.questdb.ql.ops.eq.DoubleScaledEqualOperator;
import com.questdb.ql.ops.eq.IntEqualNaNOperator;
import com.questdb.ql.ops.eq.IntEqualOperator;
import com.questdb.ql.ops.eq.LongEqualNaNOperator;
import com.questdb.ql.ops.eq.LongEqualOperator;
import com.questdb.ql.ops.eq.StrEqualDateOperator;
import com.questdb.ql.ops.eq.StrEqualNullOperator;
import com.questdb.ql.ops.eq.StrEqualStrOperator;
import com.questdb.ql.ops.eq.StrEqualSymOperator;
import com.questdb.ql.ops.eq.SymEqualStrOperator;
import com.questdb.ql.ops.first.FirstDoubleAggregator;
import com.questdb.ql.ops.first.FirstFloatAggregator;
import com.questdb.ql.ops.first.FirstIntAggregator;
import com.questdb.ql.ops.first.FirstLongAggregator;
import com.questdb.ql.ops.gt.DateGreaterThanOperator;
import com.questdb.ql.ops.gt.DateGreaterThanStrOperator;
import com.questdb.ql.ops.gt.DoubleGreaterThanOperator;
import com.questdb.ql.ops.gt.IntGreaterThanOperator;
import com.questdb.ql.ops.gt.LongGreaterThanOperator;
import com.questdb.ql.ops.gt.StrGreaterThanDateOperator;
import com.questdb.ql.ops.gte.DateGreaterOrEqualOperator;
import com.questdb.ql.ops.gte.DateGreaterOrEqualStrOperator;
import com.questdb.ql.ops.gte.DoubleGreaterOrEqualOperator;
import com.questdb.ql.ops.gte.IntGreaterOrEqualOperator;
import com.questdb.ql.ops.gte.LongGreaterOrEqualOperator;
import com.questdb.ql.ops.gte.StrGreaterOrEqualDateOperator;
import com.questdb.ql.ops.last.LastDateAggregator;
import com.questdb.ql.ops.last.LastDoubleAggregator;
import com.questdb.ql.ops.last.LastFloatAggregator;
import com.questdb.ql.ops.last.LastIntAggregator;
import com.questdb.ql.ops.last.LastLongAggregator;
import com.questdb.ql.ops.lt.DateLessThanOperator;
import com.questdb.ql.ops.lt.DateLessThanStrOperator;
import com.questdb.ql.ops.lt.DoubleLessThanOperator;
import com.questdb.ql.ops.lt.IntLessThanOperator;
import com.questdb.ql.ops.lt.LongLessThanOperator;
import com.questdb.ql.ops.lt.StrLessThanDateOperator;
import com.questdb.ql.ops.lte.DateLessOrEqualStrOperator;
import com.questdb.ql.ops.lte.DoubleLessOrEqualOperator;
import com.questdb.ql.ops.lte.IntLessOrEqualOperator;
import com.questdb.ql.ops.lte.LongLessOrEqualOperator;
import com.questdb.ql.ops.lte.StrLessOrEqualDateOperator;
import com.questdb.ql.ops.max.MaxDateAggregator;
import com.questdb.ql.ops.max.MaxDoubleAggregator;
import com.questdb.ql.ops.max.MaxIntAggregator;
import com.questdb.ql.ops.max.MaxLongAggregator;
import com.questdb.ql.ops.min.MinDateAggregator;
import com.questdb.ql.ops.min.MinDoubleAggregator;
import com.questdb.ql.ops.min.MinIntAggregator;
import com.questdb.ql.ops.min.MinLongAggregator;
import com.questdb.ql.ops.minus.MinusDoubleOperator;
import com.questdb.ql.ops.minus.MinusIntOperator;
import com.questdb.ql.ops.minus.MinusLongOperator;
import com.questdb.ql.ops.mult.MultDoubleOperator;
import com.questdb.ql.ops.mult.MultIntOperator;
import com.questdb.ql.ops.mult.MultLongOperator;
import com.questdb.ql.ops.neg.DoubleNegativeOperator;
import com.questdb.ql.ops.neg.IntNegativeOperator;
import com.questdb.ql.ops.neg.LongNegativeOperator;
import com.questdb.ql.ops.neq.DateNotEqualStrConstOperator;
import com.questdb.ql.ops.neq.DoubleNotEqualNanOperator;
import com.questdb.ql.ops.neq.DoubleNotEqualOperator;
import com.questdb.ql.ops.neq.IntNotEqualNaNOperator;
import com.questdb.ql.ops.neq.IntNotEqualOperator;
import com.questdb.ql.ops.neq.LongNotEqualNaNOperator;
import com.questdb.ql.ops.neq.LongNotEqualOperator;
import com.questdb.ql.ops.neq.StrNotEqualDateOperator;
import com.questdb.ql.ops.neq.StrNotEqualNullOperator;
import com.questdb.ql.ops.neq.StrNotEqualOperator;
import com.questdb.ql.ops.neq.StrNotEqualSymOperator;
import com.questdb.ql.ops.neq.SymNotEqualStrOperator;
import com.questdb.ql.ops.plus.AddDateDayLOperator;
import com.questdb.ql.ops.plus.AddDateDayROperator;
import com.questdb.ql.ops.plus.AddDateOperator;
import com.questdb.ql.ops.plus.AddDoubleOperator;
import com.questdb.ql.ops.plus.AddIntOperator;
import com.questdb.ql.ops.plus.AddLongOperator;
import com.questdb.ql.ops.plus.StrConcatOperator;
import com.questdb.ql.ops.regex.PluckStrFunction;
import com.questdb.ql.ops.regex.ReplaceStrWrapper;
import com.questdb.ql.ops.regex.StrRegexOperator;
import com.questdb.ql.ops.round.RoundDownFunction;
import com.questdb.ql.ops.round.RoundHalfDownFunction;
import com.questdb.ql.ops.round.RoundHalfEvenFunction;
import com.questdb.ql.ops.round.RoundHalfUpFunction;
import com.questdb.ql.ops.round.RoundUpFunction;
import com.questdb.ql.ops.stat.AvgAggregator;
import com.questdb.ql.ops.stat.StdDevAggregator;
import com.questdb.ql.ops.stat.VarAggregator;
import com.questdb.ql.ops.sum.SumDoubleAggregator;
import com.questdb.ql.ops.sum.SumIntAggregator;
import com.questdb.ql.ops.sum.SumLongAggregator;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.Chars;
import com.questdb.std.ObjList;
import com.questdb.std.ObjObjHashMap;

public final class FunctionFactories {
    private static final ObjObjHashMap<Signature, VirtualColumnFactory<Function>> factories = new ObjObjHashMap();
    private static final CharSequenceHashSet aggregateFunctionNames = new CharSequenceHashSet();

    private FunctionFactories() {
    }

    public static VirtualColumnFactory<Function> find(Signature sig, ObjList<VirtualColumn> args) {
        VirtualColumnFactory<Function> factory;
        VirtualColumn vc;
        if (sig.paramCount == 2 && (vc = args.getQuick(1)).isConstant()) {
            switch (sig.paramTypes.getQuick(1)) {
                case 2: {
                    double d = vc.getDouble(null);
                    if (d == d) break;
                    int columnType = sig.paramTypes.getQuick(0);
                    if (Chars.equals(sig.name, '=')) {
                        switch (columnType) {
                            case 2: {
                                return DoubleEqualNanOperator.FACTORY;
                            }
                            case 4: {
                                return IntEqualNaNOperator.FACTORY;
                            }
                            case 5: 
                            case 10: {
                                return LongEqualNaNOperator.FACTORY;
                            }
                        }
                        break;
                    }
                    if (!Chars.equals((CharSequence)"!=", sig.name)) break;
                    switch (columnType) {
                        case 2: {
                            return DoubleNotEqualNanOperator.FACTORY;
                        }
                        case 4: {
                            return IntNotEqualNaNOperator.FACTORY;
                        }
                        case 5: 
                        case 10: {
                            return LongNotEqualNaNOperator.FACTORY;
                        }
                    }
                    break;
                }
                case 7: {
                    if (vc.getFlyweightStr(null) != null) break;
                    int columnType = sig.paramTypes.getQuick(0);
                    if (Chars.equals(sig.name, '=')) {
                        switch (columnType) {
                            case 2: {
                                return DoubleEqualNanOperator.FACTORY;
                            }
                            case 7: {
                                return StrEqualNullOperator.FACTORY;
                            }
                            case 4: {
                                return IntEqualNaNOperator.FACTORY;
                            }
                            case 5: 
                            case 10: {
                                return LongEqualNaNOperator.FACTORY;
                            }
                        }
                        break;
                    }
                    if (!Chars.equals(sig.name, "!=")) break;
                    switch (columnType) {
                        case 2: {
                            return DoubleNotEqualNanOperator.FACTORY;
                        }
                        case 7: {
                            return StrNotEqualNullOperator.FACTORY;
                        }
                        case 4: {
                            return IntNotEqualNaNOperator.FACTORY;
                        }
                        case 5: 
                        case 10: {
                            return LongNotEqualNaNOperator.FACTORY;
                        }
                    }
                    break;
                }
            }
        }
        if ((factory = factories.get(sig)) != null) {
            return factory;
        }
        if (Chars.equals((CharSequence)"in", sig.name)) {
            switch (sig.paramTypes.getQuick(0)) {
                case 7: {
                    return StrInOperator.FACTORY;
                }
                case 8: {
                    return SymInOperator.FACTORY;
                }
                case 1: 
                case 4: 
                case 6: {
                    return IntInOperator.FACTORY;
                }
                case 5: {
                    return LongInOperator.FACTORY;
                }
                case 10: {
                    if (sig.paramCount < 3) {
                        return null;
                    }
                    return DateInOperator.FACTORY;
                }
            }
        }
        return null;
    }

    public static boolean isAggregate(CharSequence name) {
        return aggregateFunctionNames.contains(name);
    }

    private static void binSig(String name, int lhst, int rhst, VirtualColumnFactory<Function> f) {
        FunctionFactories.binSig(name, lhst, false, rhst, false, f);
        FunctionFactories.binSig(name, lhst, true, rhst, false, f);
        FunctionFactories.binSig(name, lhst, false, rhst, true, f);
        FunctionFactories.binSig(name, lhst, true, rhst, true, f);
    }

    private static void binSig(String name, int lhst, boolean lconst, int rhst, boolean rconst, VirtualColumnFactory<Function> f) {
        factories.put(new Signature().setName(name).setParamCount(2).paramType(0, lhst, lconst).paramType(1, rhst, rconst), f);
    }

    private static void binSig(String name, int lhst, int rhst, boolean rconst, VirtualColumnFactory<Function> f) {
        FunctionFactories.binSig(name, lhst, false, rhst, rconst, f);
        FunctionFactories.binSig(name, lhst, true, rhst, rconst, f);
    }

    private static void binSig(String name, int lhst, boolean lconst, int rhst, VirtualColumnFactory<Function> f) {
        FunctionFactories.binSig(name, lhst, lconst, rhst, true, f);
        FunctionFactories.binSig(name, lhst, lconst, rhst, false, f);
    }

    private static void unSig(String name, int type, VirtualColumnFactory<Function> f) {
        factories.put(new Signature().setName(name).setParamCount(1).paramType(0, type, false), f);
        factories.put(new Signature().setName(name).setParamCount(1).paramType(0, type, true), f);
    }

    private static void noargSig(String name, VirtualColumnFactory<Function> f) {
        factories.put(new Signature().setName(name).setParamCount(0), f);
    }

    private static void noargSigAgg(String name, VirtualColumnFactory<Function> f) {
        FunctionFactories.noargSig(name, f);
        aggregateFunctionNames.add(name);
    }

    private static void unSigAgg(String name, int type, VirtualColumnFactory<Function> f) {
        FunctionFactories.unSig(name, type, f);
        aggregateFunctionNames.add(name);
    }

    private static void triSig(String name, int one, int two, int three, VirtualColumnFactory<Function> f) {
        factories.put(new Signature().setName(name).setParamCount(3).paramType(0, one, false).paramType(1, two, false).paramType(2, three, false), f);
        factories.put(new Signature().setName(name).setParamCount(3).paramType(0, one, false).paramType(1, two, false).paramType(2, three, true), f);
        factories.put(new Signature().setName(name).setParamCount(3).paramType(0, one, false).paramType(1, two, true).paramType(2, three, false), f);
        factories.put(new Signature().setName(name).setParamCount(3).paramType(0, one, false).paramType(1, two, true).paramType(2, three, true), f);
        factories.put(new Signature().setName(name).setParamCount(3).paramType(0, one, true).paramType(1, two, false).paramType(2, three, false), f);
        factories.put(new Signature().setName(name).setParamCount(3).paramType(0, one, true).paramType(1, two, false).paramType(2, three, true), f);
        factories.put(new Signature().setName(name).setParamCount(3).paramType(0, one, true).paramType(1, two, true).paramType(2, three, false), f);
        factories.put(new Signature().setName(name).setParamCount(3).paramType(0, one, true).paramType(1, two, true).paramType(2, three, true), f);
    }

    private static void binSig(String name, VirtualColumnFactory<Function> doubleFactory, VirtualColumnFactory<Function> longFactory, VirtualColumnFactory<Function> intFactory) {
        FunctionFactories.binSig(name, doubleFactory, longFactory, intFactory, null);
    }

    private static void binSigAgg(String name, VirtualColumnFactory<Function> doubleFactory, VirtualColumnFactory<Function> longFactory, VirtualColumnFactory<Function> intFactory) {
        FunctionFactories.binSig(name, doubleFactory, longFactory, intFactory, null);
        aggregateFunctionNames.add(name);
    }

    private static void binSig(String name, VirtualColumnFactory<Function> doubleFactory, VirtualColumnFactory<Function> longFactory, VirtualColumnFactory<Function> intFactory, VirtualColumnFactory<Function> strFactory) {
        FunctionFactories.binSig(name, 2, 11, doubleFactory);
        FunctionFactories.binSig(name, 2, 2, doubleFactory);
        FunctionFactories.binSig(name, 2, 3, doubleFactory);
        FunctionFactories.binSig(name, 2, 4, doubleFactory);
        FunctionFactories.binSig(name, 2, 5, doubleFactory);
        FunctionFactories.binSig(name, 4, 2, doubleFactory);
        FunctionFactories.binSig(name, 4, 3, doubleFactory);
        FunctionFactories.binSig(name, 5, 2, doubleFactory);
        FunctionFactories.binSig(name, 5, 3, doubleFactory);
        FunctionFactories.binSig(name, 3, 11, doubleFactory);
        FunctionFactories.binSig(name, 3, 2, doubleFactory);
        FunctionFactories.binSig(name, 3, 3, doubleFactory);
        FunctionFactories.binSig(name, 3, 5, doubleFactory);
        FunctionFactories.binSig(name, 3, 4, doubleFactory);
        FunctionFactories.binSig(name, 5, 11, longFactory);
        FunctionFactories.binSig(name, 5, 5, longFactory);
        FunctionFactories.binSig(name, 5, 4, longFactory);
        FunctionFactories.binSig(name, 4, 5, longFactory);
        FunctionFactories.binSig(name, 4, 11, intFactory);
        FunctionFactories.binSig(name, 4, 4, intFactory);
        FunctionFactories.binSig(name, 11, 2, doubleFactory);
        FunctionFactories.binSig(name, 11, 3, doubleFactory);
        FunctionFactories.binSig(name, 11, 5, longFactory);
        FunctionFactories.binSig(name, 11, 4, intFactory);
        FunctionFactories.binSig(name, 6, 4, intFactory);
        FunctionFactories.binSig(name, 4, 6, intFactory);
        FunctionFactories.binSig(name, 6, 2, doubleFactory);
        FunctionFactories.binSig(name, 2, 6, doubleFactory);
        FunctionFactories.binSig(name, 6, 3, doubleFactory);
        FunctionFactories.binSig(name, 3, 6, doubleFactory);
        FunctionFactories.binSig(name, 6, 5, longFactory);
        FunctionFactories.binSig(name, 5, 6, longFactory);
        FunctionFactories.binSig(name, 1, 4, intFactory);
        FunctionFactories.binSig(name, 4, 1, intFactory);
        FunctionFactories.binSig(name, 1, 2, doubleFactory);
        FunctionFactories.binSig(name, 2, 1, doubleFactory);
        FunctionFactories.binSig(name, 1, 3, doubleFactory);
        FunctionFactories.binSig(name, 3, 1, doubleFactory);
        FunctionFactories.binSig(name, 1, 5, longFactory);
        FunctionFactories.binSig(name, 5, 1, longFactory);
        FunctionFactories.binSig(name, 1, 6, intFactory);
        FunctionFactories.binSig(name, 6, 1, intFactory);
        if (strFactory != null) {
            FunctionFactories.binSig(name, 7, 7, strFactory);
            FunctionFactories.binSig(name, 11, 7, strFactory);
            FunctionFactories.binSig(name, 7, 11, strFactory);
        }
    }

    static {
        FunctionFactories.binSig("+", AddDoubleOperator.FACTORY, AddLongOperator.FACTORY, AddIntOperator.FACTORY, StrConcatOperator.FACTORY);
        FunctionFactories.binSig("+", 10, 5, AddDateOperator.FACTORY);
        FunctionFactories.binSig("+", 5, 10, AddDateOperator.FACTORY);
        FunctionFactories.binSig("+", 10, 10, AddDateOperator.FACTORY);
        FunctionFactories.binSig("+", 10, 4, AddDateDayLOperator.FACTORY);
        FunctionFactories.binSig("+", 4, 10, AddDateDayROperator.FACTORY);
        FunctionFactories.binSig("*", MultDoubleOperator.FACTORY, MultLongOperator.FACTORY, MultIntOperator.FACTORY);
        FunctionFactories.binSig("/", DivDoubleOperator.FACTORY, DivDoubleOperator.FACTORY, DivDoubleOperator.FACTORY);
        FunctionFactories.binSig("-", MinusDoubleOperator.FACTORY, MinusLongOperator.FACTORY, MinusIntOperator.FACTORY);
        FunctionFactories.binSig(">", DoubleGreaterThanOperator.FACTORY, LongGreaterThanOperator.FACTORY, IntGreaterThanOperator.FACTORY);
        FunctionFactories.binSig(">", 10, 10, DateGreaterThanOperator.FACTORY);
        FunctionFactories.binSig(">", 10, 7, true, DateGreaterThanStrOperator.FACTORY);
        FunctionFactories.binSig(">", 7, true, 10, StrGreaterThanDateOperator.FACTORY);
        FunctionFactories.binSig(">=", DoubleGreaterOrEqualOperator.FACTORY, LongGreaterOrEqualOperator.FACTORY, IntGreaterOrEqualOperator.FACTORY);
        FunctionFactories.binSig(">=", 10, 10, DateGreaterOrEqualOperator.FACTORY);
        FunctionFactories.binSig(">=", 10, 7, true, DateGreaterOrEqualStrOperator.FACTORY);
        FunctionFactories.binSig(">=", 7, true, 10, StrGreaterOrEqualDateOperator.FACTORY);
        FunctionFactories.binSig("<", DoubleLessThanOperator.FACTORY, LongLessThanOperator.FACTORY, IntLessThanOperator.FACTORY);
        FunctionFactories.binSig("<", 10, 10, DateLessThanOperator.FACTORY);
        FunctionFactories.binSig("<", 10, 7, true, DateLessThanStrOperator.FACTORY);
        FunctionFactories.binSig("<", 7, true, 10, StrLessThanDateOperator.FACTORY);
        FunctionFactories.binSig("<=", DoubleLessOrEqualOperator.FACTORY, LongLessOrEqualOperator.FACTORY, IntLessOrEqualOperator.FACTORY);
        FunctionFactories.binSig("<=", 10, 10, LongLessOrEqualOperator.FACTORY);
        FunctionFactories.binSig("<=", 10, 7, true, DateLessOrEqualStrOperator.FACTORY);
        FunctionFactories.binSig("<=", 7, true, 10, StrLessOrEqualDateOperator.FACTORY);
        FunctionFactories.binSig("=", DoubleEqualOperator.FACTORY, LongEqualOperator.FACTORY, IntEqualOperator.FACTORY, StrEqualStrOperator.FACTORY);
        FunctionFactories.binSig("=", 8, false, 7, false, StrEqualStrOperator.FACTORY);
        FunctionFactories.binSig("=", 8, false, 7, true, SymEqualStrOperator.FACTORY);
        FunctionFactories.binSig("=", 8, false, 11, true, SymEqualStrOperator.FACTORY);
        FunctionFactories.binSig("=", 7, true, 8, false, StrEqualSymOperator.FACTORY);
        FunctionFactories.binSig("=", 10, 10, LongEqualOperator.FACTORY);
        FunctionFactories.binSig("=", 10, 7, true, DateEqualStrConstOperator.FACTORY);
        FunctionFactories.binSig("=", 7, true, 10, StrEqualDateOperator.FACTORY);
        FunctionFactories.binSig("!=", DoubleNotEqualOperator.FACTORY, LongNotEqualOperator.FACTORY, IntNotEqualOperator.FACTORY, StrNotEqualOperator.FACTORY);
        FunctionFactories.binSig("!=", 10, 10, LongNotEqualOperator.FACTORY);
        FunctionFactories.binSig("!=", 8, false, 7, false, StrNotEqualOperator.FACTORY);
        FunctionFactories.binSig("!=", 8, false, 7, true, SymNotEqualStrOperator.FACTORY);
        FunctionFactories.binSig("!=", 7, true, 8, false, StrNotEqualSymOperator.FACTORY);
        FunctionFactories.binSig("!=", 10, 7, true, DateNotEqualStrConstOperator.FACTORY);
        FunctionFactories.binSig("!=", 7, true, 10, StrNotEqualDateOperator.FACTORY);
        FunctionFactories.triSig("eq", 2, 2, 2, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 2, 4, 2, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 4, 2, 2, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 2, 5, 2, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 5, 2, 2, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 2, 11, 2, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 4, 11, 2, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 5, 11, 2, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 2, 11, 11, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 4, 11, 11, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 5, 11, 11, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 2, 2, 11, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 2, 4, 11, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 4, 2, 11, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 2, 5, 11, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.triSig("eq", 5, 2, 11, DoubleScaledEqualOperator.FACTORY);
        FunctionFactories.unSig("-", 4, IntNegativeOperator.FACTORY);
        FunctionFactories.unSig("-", 2, DoubleNegativeOperator.FACTORY);
        FunctionFactories.unSig("-", 5, LongNegativeOperator.FACTORY);
        FunctionFactories.unSig("not", 0, NotOperator.FACTORY);
        FunctionFactories.unSig("_stoa", 8, StoAFunction.FACTORY);
        FunctionFactories.unSig("_atos", 7, AtoSFunction.FACTORY);
        FunctionFactories.unSig("atoi", 7, AtoIFunction.FACTORY);
        FunctionFactories.unSig("atod", 7, AtoDFunction.FACTORY);
        FunctionFactories.unSig("dtol", 10, DtoLFunction.FACTORY);
        FunctionFactories.unSig("dtoa4", 10, DtoA4Function.FACTORY);
        FunctionFactories.unSig("toDate", 5, LongToDateFunction.FACTORY);
        FunctionFactories.unSig("toDate", 4, LongToDateFunction.FACTORY);
        FunctionFactories.unSig("toDate", 7, ToDateFunction.FACTORY);
        FunctionFactories.binSig("toDate", 7, false, 7, true, ToDateTwoArgFunction.FACTORY);
        FunctionFactories.binSig("toDate", 7, true, 7, true, ToDateTwoArgFunction.FACTORY);
        factories.put(new Signature().setName("toDate").setParamCount(3).paramType(0, 7, false).paramType(1, 7, true).paramType(2, 7, true), ToDateThreeArgFunction.FACTORY);
        factories.put(new Signature().setName("toDate").setParamCount(3).paramType(0, 7, true).paramType(1, 7, true).paramType(2, 7, true), ToDateThreeArgFunction.FACTORY);
        FunctionFactories.binSig("TO_CHAR", 10, false, 7, true, DateToCharFunction.FACTORY);
        FunctionFactories.binSig("TO_CHAR", 10, true, 7, true, DateToCharFunction.FACTORY);
        factories.put(new Signature().setName("TO_CHAR").setParamCount(3).paramType(0, 10, true).paramType(1, 7, true).paramType(2, 7, true), DateToCharTZFunction.FACTORY);
        factories.put(new Signature().setName("TO_CHAR").setParamCount(3).paramType(0, 10, false).paramType(1, 7, true).paramType(2, 7, true), DateToCharTZFunction.FACTORY);
        factories.put(new Signature().setName("TO_CHAR").setParamCount(4).paramType(0, 10, false).paramType(1, 7, true).paramType(2, 7, true).paramType(3, 7, true), DateToCharTZLocaleFunction.FACTORY);
        factories.put(new Signature().setName("TO_CHAR").setParamCount(4).paramType(0, 10, true).paramType(1, 7, true).paramType(2, 7, true).paramType(3, 7, true), DateToCharTZLocaleFunction.FACTORY);
        FunctionFactories.unSig("TO_DATE", 5, LongToDateFunction.FACTORY);
        FunctionFactories.unSig("TO_DATE", 4, LongToDateFunction.FACTORY);
        FunctionFactories.unSig("TO_DATE", 7, ToDateFunction.FACTORY);
        FunctionFactories.binSig("TO_DATE", 7, false, 7, true, ToDateTwoArgFunction.FACTORY);
        FunctionFactories.binSig("TO_DATE", 7, true, 7, true, ToDateTwoArgFunction.FACTORY);
        factories.put(new Signature().setName("TO_DATE").setParamCount(3).paramType(0, 7, false).paramType(1, 7, true).paramType(2, 7, true), ToDateThreeArgFunction.FACTORY);
        factories.put(new Signature().setName("TO_DATE").setParamCount(3).paramType(0, 7, true).paramType(1, 7, true).paramType(2, 7, true), ToDateThreeArgFunction.FACTORY);
        factories.put(new Signature().setName("SYSDATE").setParamCount(0), SysdateFunction.FACTORY);
        FunctionFactories.binSig("roundUp", 2, 4, RoundUpFunction.FACTORY);
        FunctionFactories.binSig("roundDown", 2, 4, RoundDownFunction.FACTORY);
        FunctionFactories.binSig("roundHalfUp", 2, 4, RoundHalfUpFunction.FACTORY);
        FunctionFactories.binSig("roundHalfDown", 2, 4, RoundHalfDownFunction.FACTORY);
        FunctionFactories.binSig("roundHalfEven", 2, 4, RoundHalfEvenFunction.FACTORY);
        FunctionFactories.binSig("~", 7, false, 7, true, StrRegexOperator.FACTORY);
        FunctionFactories.binSig("~", 7, false, 11, true, StrRegexOperator.FACTORY);
        FunctionFactories.binSig("~", 8, false, 7, true, SymRegexOperator.FACTORY);
        FunctionFactories.binSig("~", 8, false, 11, true, SymRegexOperator.FACTORY);
        FunctionFactories.binSig("and", 0, 0, AndOperator.FACTORY);
        FunctionFactories.binSig("or", 0, 0, OrOperator.FACTORY);
        FunctionFactories.unSigAgg("sum", 2, SumDoubleAggregator.FACTORY);
        FunctionFactories.unSigAgg("sum", 3, SumDoubleAggregator.FACTORY);
        FunctionFactories.unSigAgg("sum", 4, SumIntAggregator.FACTORY);
        FunctionFactories.unSigAgg("lsum", 4, SumLongAggregator.FACTORY);
        FunctionFactories.unSigAgg("sum", 5, SumLongAggregator.FACTORY);
        FunctionFactories.unSigAgg("sum", 10, SumLongAggregator.FACTORY);
        FunctionFactories.unSigAgg("first", 2, FirstDoubleAggregator.FACTORY);
        FunctionFactories.unSigAgg("first", 3, FirstFloatAggregator.FACTORY);
        FunctionFactories.unSigAgg("first", 4, FirstIntAggregator.FACTORY);
        FunctionFactories.unSigAgg("first", 5, FirstLongAggregator.FACTORY);
        FunctionFactories.unSigAgg("first", 10, FirstLongAggregator.FACTORY);
        FunctionFactories.unSigAgg("last", 2, LastDoubleAggregator.FACTORY);
        FunctionFactories.unSigAgg("last", 3, LastFloatAggregator.FACTORY);
        FunctionFactories.unSigAgg("last", 4, LastIntAggregator.FACTORY);
        FunctionFactories.unSigAgg("last", 5, LastLongAggregator.FACTORY);
        FunctionFactories.unSigAgg("last", 10, LastDateAggregator.FACTORY);
        FunctionFactories.unSigAgg("avg", 2, AvgAggregator.FACTORY);
        FunctionFactories.unSigAgg("avg", 4, AvgAggregator.FACTORY);
        FunctionFactories.unSigAgg("avg", 5, AvgAggregator.FACTORY);
        FunctionFactories.unSigAgg("avg", 3, AvgAggregator.FACTORY);
        FunctionFactories.unSigAgg("var", 2, VarAggregator.FACTORY);
        FunctionFactories.unSigAgg("var", 4, VarAggregator.FACTORY);
        FunctionFactories.unSigAgg("var", 5, VarAggregator.FACTORY);
        FunctionFactories.unSigAgg("var", 3, VarAggregator.FACTORY);
        FunctionFactories.unSigAgg("stddev", 2, StdDevAggregator.FACTORY);
        FunctionFactories.unSigAgg("stddev", 4, StdDevAggregator.FACTORY);
        FunctionFactories.unSigAgg("stddev", 5, StdDevAggregator.FACTORY);
        FunctionFactories.unSigAgg("stddev", 3, StdDevAggregator.FACTORY);
        FunctionFactories.binSigAgg("vwap", VwapAggregator.FACTORY, VwapAggregator.FACTORY, VwapAggregator.FACTORY);
        FunctionFactories.unSigAgg("min", 2, MinDoubleAggregator.FACTORY);
        FunctionFactories.unSigAgg("min", 3, MinDoubleAggregator.FACTORY);
        FunctionFactories.unSigAgg("min", 4, MinIntAggregator.FACTORY);
        FunctionFactories.unSigAgg("min", 5, MinLongAggregator.FACTORY);
        FunctionFactories.unSigAgg("min", 10, MinDateAggregator.FACTORY);
        FunctionFactories.unSigAgg("max", 2, MaxDoubleAggregator.FACTORY);
        FunctionFactories.unSigAgg("max", 3, MaxDoubleAggregator.FACTORY);
        FunctionFactories.unSigAgg("max", 4, MaxIntAggregator.FACTORY);
        FunctionFactories.unSigAgg("max", 5, MaxLongAggregator.FACTORY);
        FunctionFactories.unSigAgg("max", 10, MaxDateAggregator.FACTORY);
        FunctionFactories.noargSigAgg("count", CountAggregator.FACTORY);
        FunctionFactories.unSigAgg("count", 2, CountDoubleAggregator.FACTORY);
        FunctionFactories.unSigAgg("count", 3, CountFloatAggregator.FACTORY);
        FunctionFactories.unSigAgg("count", 4, CountIntAggregator.FACTORY);
        FunctionFactories.unSigAgg("count", 5, CountLongAggregator.FACTORY);
        FunctionFactories.unSigAgg("count", 10, CountLongAggregator.FACTORY);
        FunctionFactories.unSigAgg("count", 7, CountStrAggregator.FACTORY);
        FunctionFactories.unSigAgg("count", 8, CountSymAggregator.FACTORY);
        factories.put(new Signature().setName("pluck").setParamCount(2).paramType(0, 7, true).paramType(1, 7, false), PluckStrFunction.FACTORY);
        factories.put(new Signature().setName("pluck").setParamCount(2).paramType(0, 7, true).paramType(1, 7, true), PluckStrFunction.FACTORY);
        factories.put(new Signature().setName("replace").setParamCount(3).paramType(0, 7, true).paramType(1, 7, true).paramType(2, 7, false), ReplaceStrWrapper.FACTORY);
        factories.put(new Signature().setName("replace").setParamCount(3).paramType(0, 7, true).paramType(1, 7, true).paramType(2, 7, true), ReplaceStrWrapper.FACTORY);
        FunctionFactories.unSig("typeOf", 9, TypeOfFunction.FACTORY);
        FunctionFactories.unSig("typeOf", 0, TypeOfFunction.FACTORY);
        FunctionFactories.unSig("typeOf", 1, TypeOfFunction.FACTORY);
        FunctionFactories.unSig("typeOf", 10, TypeOfFunction.FACTORY);
        FunctionFactories.unSig("typeOf", 2, TypeOfFunction.FACTORY);
        FunctionFactories.unSig("typeOf", 3, TypeOfFunction.FACTORY);
        FunctionFactories.unSig("typeOf", 4, TypeOfFunction.FACTORY);
        FunctionFactories.unSig("typeOf", 5, TypeOfFunction.FACTORY);
        FunctionFactories.unSig("typeOf", 6, TypeOfFunction.FACTORY);
        FunctionFactories.unSig("typeOf", 7, TypeOfFunction.FACTORY);
        FunctionFactories.unSig("typeOf", 8, TypeOfFunction.FACTORY);
    }
}

