/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops;

import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.ex.ParserException;
import com.questdb.ql.ops.AbstractVirtualColumn;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.IntHashSet;

public class IntInOperator
extends AbstractVirtualColumn
implements Function {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new IntInOperator(position);
    private final IntHashSet set = new IntHashSet();
    private VirtualColumn lhs;

    private IntInOperator(int position) {
        super(0, position);
    }

    @Override
    public boolean getBool(Record rec) {
        return this.set.contains(this.lhs.getInt(rec));
    }

    @Override
    public boolean isConstant() {
        return this.lhs.isConstant();
    }

    @Override
    public void prepare(StorageFacade facade) {
        this.lhs.prepare(facade);
    }

    @Override
    public void setArg(int pos, VirtualColumn arg) throws ParserException {
        if (pos == 0) {
            this.lhs = arg;
        } else {
            IntInOperator.assertConstant(arg);
            switch (arg.getType()) {
                case 2: {
                    double d = arg.getDouble(null);
                    if (d != d) {
                        this.set.add(Integer.MIN_VALUE);
                        break;
                    }
                    IntInOperator.typeError(arg.getPosition(), 4);
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    this.set.add(arg.getInt(null));
                    break;
                }
                default: {
                    IntInOperator.typeError(arg.getPosition(), 4);
                }
            }
        }
    }
}

