/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops;

import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.ex.ParserException;
import com.questdb.ql.ops.AbstractVirtualColumn;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.LongHashSet;

public class LongInOperator
extends AbstractVirtualColumn
implements Function {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new LongInOperator(position);
    private final LongHashSet set = new LongHashSet();
    private VirtualColumn lhs;

    private LongInOperator(int position) {
        super(0, position);
    }

    @Override
    public boolean getBool(Record rec) {
        return this.set.contains(this.lhs.getLong(rec));
    }

    @Override
    public boolean isConstant() {
        return this.lhs.isConstant();
    }

    @Override
    public void prepare(StorageFacade facade) {
        this.lhs.prepare(facade);
    }

    @Override
    public void setArg(int pos, VirtualColumn arg) throws ParserException {
        if (pos == 0) {
            this.lhs = arg;
        } else {
            LongInOperator.assertConstant(arg);
            switch (arg.getType()) {
                case 2: {
                    double d = arg.getDouble(null);
                    if (d != d) {
                        this.set.add(Long.MIN_VALUE);
                        break;
                    }
                    LongInOperator.typeError(arg.getPosition(), 5);
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    this.set.add(arg.getLong(null));
                    break;
                }
                default: {
                    LongInOperator.typeError(arg.getPosition(), 5);
                }
            }
        }
    }
}

