/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops;

import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.ex.UndefinedParameterException;
import com.questdb.ex.WrongParameterTypeException;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.ql.ops.AbstractVirtualColumn;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.CharSequenceObjHashMap;

public class Parameter
extends AbstractVirtualColumn {
    private int valueType = 11;
    private long longValue;
    private double doubleValue;
    private String stringValue;

    private Parameter(int position) {
        super(11, position);
    }

    public static VirtualColumn getOrCreate(ExprNode node, CharSequenceObjHashMap<Parameter> parameterMap) {
        Parameter p = parameterMap.get(node.token);
        if (p == null) {
            p = new Parameter(node.position);
            parameterMap.put(node.token, p);
            p.setName(node.token);
        }
        return p;
    }

    @Override
    public byte get(Record rec) {
        switch (this.valueType) {
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return (byte)this.longValue;
            }
        }
        throw this.wrongType(1);
    }

    @Override
    public double getDouble(Record rec) {
        switch (this.valueType) {
            case 2: 
            case 3: {
                return this.doubleValue;
            }
        }
        throw this.wrongType(2);
    }

    @Override
    public float getFloat(Record rec) {
        switch (this.valueType) {
            case 2: 
            case 3: {
                return (float)this.doubleValue;
            }
        }
        throw this.wrongType(2);
    }

    @Override
    public CharSequence getFlyweightStr(Record rec) {
        switch (this.valueType) {
            case 7: {
                return this.stringValue;
            }
        }
        throw this.wrongType(7);
    }

    @Override
    public CharSequence getFlyweightStrB(Record rec) {
        return this.getFlyweightStr(rec);
    }

    @Override
    public int getInt(Record rec) {
        switch (this.valueType) {
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return (int)this.longValue;
            }
        }
        throw this.wrongType(4);
    }

    @Override
    public long getLong(Record rec) {
        switch (this.valueType) {
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return this.longValue;
            }
        }
        throw this.wrongType(5);
    }

    @Override
    public short getShort(Record rec) {
        switch (this.valueType) {
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return (short)this.longValue;
            }
        }
        throw this.wrongType(6);
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public void prepare(StorageFacade facade) {
    }

    public void set(int value) {
        this.valueType = 4;
        this.longValue = value;
    }

    public void set(short value) {
        this.valueType = 6;
        this.longValue = value;
    }

    public void set(byte value) {
        this.valueType = 1;
        this.longValue = value;
    }

    public void set(double value) {
        this.valueType = 2;
        this.doubleValue = value;
    }

    public void set(float value) {
        this.valueType = 3;
        this.doubleValue = value;
    }

    public void set(String value) {
        this.valueType = 7;
        this.stringValue = value;
    }

    public void set(long value) {
        this.valueType = 5;
        this.longValue = value;
    }

    public void setDate(long value) {
        this.valueType = 10;
        this.longValue = value;
    }

    private RuntimeException wrongType(int expected) {
        if (this.valueType == 11) {
            return new UndefinedParameterException(this.getName());
        }
        return new WrongParameterTypeException(this.getName(), expected, this.valueType);
    }
}

