/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops;

import com.questdb.common.ColumnType;
import com.questdb.std.IntList;
import com.questdb.std.Misc;
import com.questdb.std.Mutable;
import com.questdb.std.str.StringSink;

public final class Signature
implements Mutable {
    public final IntList paramTypes = new IntList(2);
    private final IntList constParams = new IntList(2);
    public CharSequence name;
    public int paramCount;

    @Override
    public void clear() {
        this.paramTypes.clear();
    }

    public int hashCode() {
        return this.typesHashCode(31 * this.name.hashCode() + this.paramCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Signature)) {
            return false;
        }
        Signature that = (Signature)o;
        return this.paramCount == that.paramCount && this.name.equals(that.name) && this.typesEqual(that);
    }

    public Signature paramType(int pos, int columnType, boolean constant) {
        this.paramTypes.setQuick(pos, columnType);
        this.constParams.setQuick(pos, constant ? 1 : 0);
        return this;
    }

    public Signature setName(CharSequence name) {
        this.name = name;
        return this;
    }

    public Signature setParamCount(int paramCount) {
        this.paramCount = paramCount;
        this.paramTypes.ensureCapacity(paramCount);
        this.constParams.ensureCapacity(paramCount);
        return this;
    }

    public CharSequence userReadable() {
        StringSink b = Misc.getThreadLocalBuilder();
        b.put('\'');
        b.put(this.name);
        b.put('\'');
        b.put('(');
        int n = this.paramCount;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                b.put(", ");
            }
            if (this.constParams.getQuick(i) == 1) {
                b.put("const ");
            }
            b.put(ColumnType.nameOf(this.paramTypes.getQuick(i)));
        }
        b.put(')');
        return b;
    }

    private boolean typesEqual(Signature that) {
        int k = this.paramTypes.size();
        if (k != that.paramTypes.size()) {
            return false;
        }
        for (int i = 0; i < k; ++i) {
            if (this.paramTypes.getQuick(i) == that.paramTypes.getQuick(i) && this.constParams.getQuick(i) == that.constParams.getQuick(i)) continue;
            return false;
        }
        return true;
    }

    private int typesHashCode(int h) {
        int k = this.paramTypes.size();
        for (int i = 0; i < k; ++i) {
            h = h * 32 + this.paramTypes.getQuick(i);
            h = h * 32 + this.constParams.getQuick(i);
        }
        return h;
    }
}

