/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops;

import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.ex.ParserException;
import com.questdb.ql.ops.AbstractVirtualColumn;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.CharSequenceHashSet;

public class StrInOperator
extends AbstractVirtualColumn
implements Function {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new StrInOperator(position);
    private final CharSequenceHashSet set = new CharSequenceHashSet();
    private VirtualColumn lhs;

    private StrInOperator(int position) {
        super(0, position);
    }

    @Override
    public boolean getBool(Record rec) {
        return this.set.contains(this.lhs.getFlyweightStr(rec));
    }

    @Override
    public boolean isConstant() {
        return this.lhs.isConstant();
    }

    @Override
    public void prepare(StorageFacade facade) {
        this.lhs.prepare(facade);
    }

    @Override
    public void setArg(int pos, VirtualColumn arg) throws ParserException {
        if (pos == 0) {
            this.lhs = arg;
        } else {
            StrInOperator.assertConstant(arg);
            switch (arg.getType()) {
                case 7: {
                    CharSequence cs = arg.getFlyweightStr(null);
                    this.set.add(cs == null ? null : cs.toString());
                    break;
                }
                default: {
                    StrInOperator.typeError(arg.getPosition(), 7);
                }
            }
        }
    }
}

