/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops;

import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.common.SymbolTable;
import com.questdb.ex.ParserException;
import com.questdb.ql.ops.AbstractVirtualColumn;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.IntHashSet;

public class SymInOperator
extends AbstractVirtualColumn
implements Function {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new SymInOperator(position);
    private final IntHashSet set = new IntHashSet(10, 0.5, -10);
    private final CharSequenceHashSet values = new CharSequenceHashSet();
    private VirtualColumn lhs;

    private SymInOperator(int position) {
        super(0, position);
    }

    @Override
    public boolean getBool(Record rec) {
        return this.set.contains(this.lhs.getInt(rec));
    }

    @Override
    public boolean isConstant() {
        return this.lhs.isConstant();
    }

    @Override
    public void prepare(StorageFacade facade) {
        this.lhs.prepare(facade);
        SymbolTable tab = this.lhs.getSymbolTable();
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            this.set.add(tab.getQuick(this.values.get(i)));
        }
    }

    @Override
    public void setArg(int pos, VirtualColumn arg) throws ParserException {
        if (pos == 0) {
            this.lhs = arg;
        } else {
            SymInOperator.assertConstant(arg);
            switch (arg.getType()) {
                case 7: {
                    CharSequence cs = arg.getFlyweightStr(null);
                    this.values.add(cs == null ? null : cs.toString());
                    break;
                }
                default: {
                    SymInOperator.typeError(arg.getPosition(), 7);
                }
            }
        }
    }
}

