/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops;

import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.common.SymbolTable;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.ops.AbstractBinaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.ql.ops.regex.Matcher;
import com.questdb.ql.ops.regex.Pattern;
import com.questdb.ql.ops.regex.PatternSyntaxException;
import com.questdb.std.IntHashSet;

public class SymRegexOperator
extends AbstractBinaryOperator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new SymRegexOperator(position);
    private final IntHashSet set = new IntHashSet();
    private Matcher matcher;

    private SymRegexOperator(int position) {
        super(0, position);
    }

    @Override
    public boolean getBool(Record rec) {
        return this.set.contains(this.lhs.getInt(rec));
    }

    @Override
    public void prepare(StorageFacade facade) {
        super.prepare(facade);
        this.set.clear();
        SymbolTable tab = this.lhs.getSymbolTable();
        int n = tab.size();
        for (int i = 0; i < n; ++i) {
            if (!this.matcher.reset(tab.value(i)).find()) continue;
            this.set.add(i);
        }
    }

    @Override
    public void setRhs(VirtualColumn rhs) throws ParserException {
        super.setRhs(rhs);
        CharSequence pattern = rhs.getFlyweightStr(null);
        if (pattern == null) {
            throw QueryError.$(rhs.getPosition(), "null regex?");
        }
        try {
            this.matcher = Pattern.compile(pattern.toString()).matcher("");
        }
        catch (PatternSyntaxException e) {
            throw QueryError.position(rhs.getPosition() + e.getIndex() + 2).$("Regex syntax error. ").$(e.getDescription()).$();
        }
    }
}

