/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops;

import com.questdb.common.Record;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.ql.AggregatorFunction;
import com.questdb.ql.RecordColumnMetadataImpl;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.MapRecordValueInterceptor;
import com.questdb.ql.ops.AbstractBinaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.ObjList;
import com.questdb.store.factory.configuration.ColumnMetadata;

public final class VwapAggregator
extends AbstractBinaryOperator
implements AggregatorFunction,
MapRecordValueInterceptor {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new VwapAggregator(position);
    private static final RecordColumnMetadata INTERNAL_COL_AMOUNT = new RecordColumnMetadataImpl("$sumAmt", 2);
    private static final RecordColumnMetadata INTERNAL_COL_QUANTITY = new RecordColumnMetadataImpl("$sumQty", 2);
    private int sumAmtIdx;
    private int sumQtyIdx;
    private int vwap;

    private VwapAggregator(int position) {
        super(2, position);
    }

    @Override
    public void beforeRecord(DirectMapValues values) {
        values.putDouble(this.vwap, values.getDouble(this.sumAmtIdx) / values.getDouble(this.sumQtyIdx));
    }

    @Override
    public void calculate(Record rec, DirectMapValues values) {
        double price = this.lhs.getDouble(rec);
        double quantity = this.rhs.getDouble(rec);
        if (values.isNew()) {
            values.putDouble(this.sumAmtIdx, price * quantity);
            values.putDouble(this.sumQtyIdx, quantity);
        } else {
            values.putDouble(this.sumAmtIdx, values.getDouble(this.sumAmtIdx) + price * quantity);
            values.putDouble(this.sumQtyIdx, values.getDouble(this.sumQtyIdx) + quantity);
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public void prepare(ObjList<RecordColumnMetadata> columns, int offset) {
        columns.add(INTERNAL_COL_AMOUNT);
        columns.add(INTERNAL_COL_QUANTITY);
        columns.add(new ColumnMetadata().setName(this.getName()).setType(2));
        this.sumAmtIdx = offset;
        this.sumQtyIdx = offset + 1;
        this.vwap = offset + 2;
    }

    @Override
    public boolean isConstant() {
        return false;
    }
}

