/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.conv;

import com.questdb.common.Record;
import com.questdb.ex.ParserException;
import com.questdb.ql.ops.AbstractBinaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.std.time.DateFormat;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocale;

public class DateToCharFunction
extends AbstractBinaryOperator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, env) -> new DateToCharFunction(position, env.dateFormatFactory, env.dateLocaleFactory.getDefaultDateLocale());
    private static final String ZONE = "Z";
    private final DateFormatFactory dateFormatFactory;
    private final DateLocale dateLocale;
    private final StringSink sinkA = new StringSink();
    private final StringSink sinkB = new StringSink();
    private DateFormat fmt;

    private DateToCharFunction(int position, DateFormatFactory dateFormatFactory, DateLocale defaultLocale) {
        super(7, position);
        this.dateFormatFactory = dateFormatFactory;
        this.dateLocale = defaultLocale;
    }

    @Override
    public CharSequence getFlyweightStr(Record rec) {
        return this.getFlyweightStr0(rec, this.sinkA);
    }

    @Override
    public CharSequence getFlyweightStrB(Record rec) {
        return this.getFlyweightStr0(rec, this.sinkB);
    }

    @Override
    public void getStr(Record rec, CharSink sink) {
        long instant = this.lhs.getLong(rec);
        if (instant > Long.MIN_VALUE) {
            this.fmt.format(instant, this.dateLocale, ZONE, sink);
        }
    }

    @Override
    public void setRhs(VirtualColumn rhs) throws ParserException {
        super.setRhs(rhs);
        this.fmt = this.dateFormatFactory.get(rhs.getFlyweightStr(null));
    }

    private CharSequence getFlyweightStr0(Record rec, StringSink sink) {
        long instant = this.lhs.getLong(rec);
        if (instant == Long.MIN_VALUE) {
            return null;
        }
        sink.clear();
        this.fmt.format(instant, this.dateLocale, ZONE, sink);
        return sink;
    }
}

